package com.rocoinfo.rocomall.shiro.token;

import com.rocoinfo.rocomall.enumconst.UserType;
import org.apache.shiro.authc.UsernamePasswordToken;

/**
 * <dl>
 * <dd>Description: 重写Shiro的用户名密码token,为了携带前后台用户登录标识</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/7/4 15:36</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class MyUsernamePasswordToken extends UsernamePasswordToken {

    /**
     * 用户登录标识:前台or后台
     */
    private UserType userType;

    public MyUsernamePasswordToken(String username, String password, boolean rememberMe, UserType userType) {
        super(username, password, rememberMe);
        this.userType = userType;
    }

    public UserType getUserType() {
        return userType;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }
}
