package com.rocoinfo.rocomall.utils;



import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;

/**
 * <dl>
 * <dd>描述:entity bean to map </dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/9/8  上午11:40</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public class ClassToMapUtil {
    private static Logger logger = LoggerFactory.getLogger(ClassToMapUtil.class);

    //值处理list<entity> 和entity两种对象类型
    public static Object dealSimple(Object obj, String... paramFields){
        if(obj==null)
            return null;

        List<String> needFields = Arrays.asList(paramFields);
        if (obj instanceof Collection){
            List list = (List)obj;
            List reData = new ArrayList(list.size());
            for (Object dealObj : list){
                reData.add(classToMapSimple(dealObj, needFields));
            }
            return reData;
        }else{
           return classToMapSimple(obj, needFields);
        }
    }

    //处理带导航的属性
    private static Map<String, List<String>> dealAttrSimple(List<String> attrNames){

        Map<String, List<String>> subFieldsMap = new HashMap<String, List<String>>(attrNames.size());
        List<String> subFieldsList = null;

        String objName = null;
        String attrName = null;
        if (attrNames.size()>0){
            for (String fieldName :attrNames){

                if (fieldName.indexOf(".") < 0) {//对象简单属性
                    subFieldsMap.put(fieldName,null);
                }else{//带导航属性 catalog_.name
                    objName = fieldName.substring(0, fieldName.indexOf("."));//对象名
                    attrName = fieldName.substring(fieldName.indexOf(".") + 1);//对象属性

                    if (subFieldsMap.containsKey(objName)){
                        List<String> mapList = (List<String>)subFieldsMap.get(objName);
                        mapList.add(attrName);
                        subFieldsMap.put(objName,mapList);
                    }else{
                        subFieldsList = new ArrayList<String>();
                        subFieldsList.add(attrName);
                        subFieldsMap.put(objName, subFieldsList);
                    }
                }
            }
        }
        return subFieldsMap;
    }

    //获取对象的属性值
    private static Map<String, Object> classToMapSimple(Object obj, List<String> paramFields){

        Map<String, Object> ret = new HashMap<String, Object>();
        try {
            List<String> dotFields = new ArrayList<String>();//带点的属性

            for (String paramField :paramFields){
                if (paramField.indexOf(".") < 0) {//对象简单属性
                    ret.put(paramField, ReflectionUtils.getFieldValue(obj, paramField));
                }else{
                    dotFields.add(paramField);//带导航的属性
                }
            }

            //处理带点的属性 type.id
            Map<String, List<String>> subFieldsMap = dealAttrSimple(dotFields);

            Object fieldValue = null;
            for (String objKey :subFieldsMap.keySet()){
                fieldValue = ReflectionUtils.getFieldValue(obj, objKey);
                if (fieldValue==null)
                    continue;

                //对象 type.id
                if (fieldValue.getClass().getName().indexOf("entity")>=0){
                    ret.put(objKey,classToMapSimple(fieldValue, subFieldsMap.get(objKey)));
                }

                //list catalogs.id
                if (fieldValue instanceof Collection) {

                    List<Object> valueList = (List<Object>)fieldValue;

                    if (valueList.get(0).getClass().getName().indexOf("entity")>=0){//是对象 才处理

                        List<Object> objList = new ArrayList<Object>(valueList.size());
                        for (Object valueObj :valueList){
                            objList.add((Object)classToMapSimple(valueObj, subFieldsMap.get(objKey)));
                        }

                        ret.put(objKey,objList);
                    }
                }

                //map userMap.key.id  或userMap.key
                if (fieldValue instanceof Map) {

                    Map<String,Object> mapValue = ( Map<String,Object>)fieldValue;

                    List<String> mapAttrList = (List<String>) subFieldsMap.get(objKey);

                    Map<String, List<String>> valueFieldsMap = dealAttrSimple(mapAttrList);

                    Map<String, Object> tmMap =  new HashMap<String, Object>(valueFieldsMap.size());

                    List<String> attrList = null;
                    for (String mapField :valueFieldsMap.keySet()){
                        attrList = valueFieldsMap.get(mapField);
                        if (attrList != null){//map.catalogs.id
                            tmMap.put(mapField, classToMapSimple(mapValue.get(mapField), valueFieldsMap.get(mapField)));
                        }else{//map.brand_
                            tmMap.put(mapField, mapValue.get(mapField));
                        }
                    }

                    ret.put(objKey,tmMap);
                }
            }
        } catch (Exception e) {
            logger.error("classToMapSimple exception",e);
        }
        return ret;
    }

}
