package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.entity.Sku;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.*;

/**
 * @author zhangmin 描述：自定义定制fn 函数
 */
public final class CustomFunctions {

	/** 返回字符串的前maxWidth个字符 */
	public static String abbreviate(final String str, final int maxWidth) {
		if (StringUtils.isBlank(str)) {
			return StringUtils.EMPTY;
		}

		if (maxWidth < 4)
			return str;
		return StringUtils.abbreviate(str, maxWidth);
	}

	public static boolean contains(List<Object> itemList, Object item) {
		if (!CollectionUtils.isEmpty(itemList)) {
			return itemList.contains(item);
		}
		return false;
	}

	public static String encode(final String paramValue, final String charSet) {
		try {
			return java.net.URLEncoder.encode(paramValue, charSet);
		} catch (UnsupportedEncodingException e) {
			return paramValue;
		}
	}

	/***
	 * 处理网页显示的金额，如果是小数最多保留2为小数 <br/>
	 * 100.00 =>100 100.0 =>100 <br/>
	 * 1.24e2 =>124
	 * 
	 * @param amount 金额
	 */
	public static String renderMoney(double amount) {
		String money = StringUtils.EMPTY;
		int intPart = (int) amount;
		if (amount != intPart) {
			NumberFormat fmt = NumberFormat.getInstance();
			fmt.setMaximumFractionDigits(2);
			money = fmt.format(amount);
			money = money.replace(",", StringUtils.EMPTY);
		} else {
			money = String.valueOf(intPart);
		}
		return money;
	}

	public static Map<String, List<String>> canDoMap = new HashMap<String, List<String>>();
	static {
		List<String> draft = new ArrayList<String>(3);
		draft.add("discard");
		draft.add("submitAudit");
		draft.add("edit");
		canDoMap.put("DRAFT", draft);

		List<String> discard = new ArrayList<String>(0);
		canDoMap.put("DISCARD", discard);

		List<String> audit = new ArrayList<String>(3);
		audit.add("auditRefuse");
		audit.add("auditOk");
		canDoMap.put("AUDIT", audit);

		List<String> refuse = new ArrayList<String>(2);
		refuse.add("discard");
		refuse.add("edit");
		canDoMap.put("REFUSE", refuse);

		List<String> ready_list = new ArrayList<String>(2);
		ready_list.add("list");
		ready_list.add("edit");
		canDoMap.put("READY_LIST", ready_list);

		List<String> list = new ArrayList<String>(1);
		list.add("deList");
		canDoMap.put("LIST", list);

		List<String> delist = new ArrayList<String>(2);
		delist.add("list");
		delist.add("edit");
		canDoMap.put("DELIST", delist);
	}

	public static boolean canDo(Sku sku, String action) {
		//当前时间大于定时下架时间，不允许上架
		if (action == "list" && sku.getProduct().getDelistTime() != null && new Date().getTime() > sku.getProduct().getDelistTime().getTime()) {
			return false;
		}
		//判断是否符合业务流程
		return canDoMap.get(sku.getProduct().getStatus().name()) != null && (canDoMap.get(sku.getProduct().getStatus().name()).contains(action));
	}

}