package com.rocoinfo.rocomall.utils;

import com.rocoinfo.rocomall.PropertyHolder;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.ServletContext;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

/**
 * <dl>
 * <dd>描述:生成js</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年9月15日 下午2:07:55</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public final class JsGenerator {
	static final String slash = File.separator;

	enum AttachPage {
		index, list;
	}

	public static enum JsBlock {
		catalog(AttachPage.index), banner(AttachPage.index), settingProdBlock(AttachPage.index), //
		brand(AttachPage.list), hotExchange(AttachPage.list), prodList(AttachPage.list);

		JsBlock(AttachPage attachTo) {
			this.attachTo = attachTo;
		}

		private AttachPage attachTo;

		public AttachPage getAttachTo() {
			return attachTo;
		}
	}

	public static void generateJsFile(String jsonJsBody, JsBlock block) throws IOException {
		//js文件名格式：pagePath/blockPath.js
		String fileName = block.name() + ".js";
		writeFile(jsonJsBody, block, fileName, false);
	}

	public static void generateHashJsFile(ServletContext ctx, String jsonJsBody, JsBlock block) throws IOException {
		//js文件名格式：pagePath/blockPath-md5(jsbody).js,例如:index/catalog-d97edf2195dff36104426230c0174fae.js
		String pagePath = block.getAttachTo().name();
		final String joinChar = "-";
		String md5 = DigestUtils.md5Hex(jsonJsBody);
		String md5CtxAttruteName = pagePath + joinChar + block.name();
		ctx.setAttribute(md5CtxAttruteName, md5);
		String fileName = block.name() + joinChar + md5 + ".js";
		writeFile(jsonJsBody, block, fileName, true);
	}

	private static void writeFile(String jsonJsBody, JsBlock block, String fileName, boolean isCleanOldVersionFile) throws IOException {
		String pagePath = block.getAttachTo().name();
		String dir = PropertyHolder.getJsGenerateDir() + slash + pagePath;
		File saveToDir = new File(dir);
		if (!saveToDir.exists()) {
			saveToDir.mkdirs();
		}
		if (StringUtils.isNotBlank(jsonJsBody)) {
			String jsFileContentFormat = "var _%s=%s;";
			jsonJsBody = String.format(jsFileContentFormat, block.name().toUpperCase(), jsonJsBody);
		}

		if (isCleanOldVersionFile) {
			clearOldVersionJsFile(saveToDir, block);
		}

		File jsFile = new File(saveToDir, fileName);
		FileUtils.write(jsFile, jsonJsBody);
	}

	//清除以前的垃圾文件
	private static void clearOldVersionJsFile(File jsFileDir, final JsBlock block) {
		File[] removeFiles = jsFileDir.listFiles(new FilenameFilter() {
			@Override
			public boolean accept(File dir, String name) {
				return name.startsWith(block.name());
			}
		});

		if (removeFiles != null && removeFiles.length > 0) {
			for (File rmFile : removeFiles) {
				FileUtils.deleteQuietly(rmFile);
			}
		}

	}
}
