package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeTemplateService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

@Controller
@RequestMapping("/expressTemplate")
public class ExpressTemplateController extends BaseController {
	@Autowired
	protected IDictProviceCityService provCityService;
	@Autowired
	private IExpressFeeTemplateService expressTemplateService;

	@RequestMapping(value = "create")
	public String createUI(Model model) {
		model.addAttribute("provCityList", provCityService.buildProvCityNodes(null));
		return "express/express_fee_template";
	}

	private void buildFeeItemCityNames(ExpressFeeTemplate feeTemplate) {
		if (feeTemplate != null && CollectionUtils.isNotEmpty(feeTemplate.getItems())) {
			for (ExpressFeeItem item : feeTemplate.getItems()) {
				StringBuilder idBuf = new StringBuilder();
				List<FeeItemCity> itemCityList = item.getItemCitys();
				for (FeeItemCity itemCity : itemCityList) {
					idBuf.append(itemCity.getCityId()).append(",");
				}

				if (idBuf.length() > 0) {
					idBuf.deleteCharAt(idBuf.length() - 1);
					item.setCityIds(idBuf.toString());
				}
			}
		}
	}

	@RequestMapping(value = "/update/{id}", method = RequestMethod.GET)
	public String updateUI(@PathVariable Long id, Model model) {
		ExpressFeeTemplate feeTemplate = expressTemplateService.getTemplateDetailById(id);
		buildFeeItemCityNames(feeTemplate);

		model.addAttribute("provCityList", provCityService.buildProvCityNodes(null));
		model.addAttribute("feeTemplate", feeTemplate);
		return "express/express_fee_template_edit";
	}
}