package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.shiro.session.PubSubHandle;
import org.springframework.web.context.support.WebApplicationContextUtils;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

/**
 */
public class InitSubscribeServlet extends HttpServlet {

	private static final long serialVersionUID = 6965568201019057246L;
	PubSubHandle pubSubHandle;

	public void init() throws ServletException {
		pubSubHandle = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext()).getBean(PubSubHandle.class);
		if (pubSubHandle != null) {
			pubSubHandle.subscribe();
		}
	}

	@Override
	public void destroy() {
		super.destroy();
		if (pubSubHandle != null) {
			//取消订阅所有的通道
			pubSubHandle.unsubscribe();
		}
	}
}
