package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.service.impl.AdminUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * <dl>
 * <dd>描述: 角色管理</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年8月5日 下午3:23:29</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Controller
@RequestMapping("/roleAction")
public class RoleController {

	enum RoleOrderProperty {
		id, name
	}

	@Autowired
	private AdminUserService adminService;

	@RequestMapping(method = RequestMethod.GET)
	public String list(@RequestParam(required = false) String name, @RequestParam(defaultValue = "1") int pageNumber, @RequestParam(defaultValue = Constants.DEFAULT_PAGE_SIZE_STR) int pageSize,
		@RequestParam(defaultValue = "id") RoleOrderProperty roleOrderProperty, @RequestParam(defaultValue = "DESC") Sort.Direction orderDirection, Model model) {
		Role params = new Role();
		params.setName(name);
		Pageable pageable = new PageRequest(pageNumber - 1, pageSize, new Sort(orderDirection, roleOrderProperty.name()));
		adminService.findAllRole();
		model.addAttribute("roleList", adminService.findAllRole());
		return "role/list";
	}
}
