package com.rocoinfo.rocomall.web;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.utils.CaptchaUtil;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author zhangmin
 */
@Controller
public final class VerifyCodeController {

	@RequestMapping(value = "/generateVerifyCode", method = RequestMethod.GET)
	public void generate(HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("image/png");
		Servlets.setNoCacheHeader(response);
		try {
			String captcha = CaptchaUtil.captcha(response.getOutputStream(), "png");
			WebUtils.getSession().setAttribute(Constants.SESSION_ATTR_VERIFY_CODE_KEY, captcha);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
}
