/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.common;

import com.rocoinfo.rocomall.common.QueryDataException;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

public abstract class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }

    @ExceptionHandler(value={QueryDataException.class})
    public Object queryDataException(Exception ex) {
        this.logger.error("\u6570\u636e\u67e5\u8be2\u5f02\u5e38:", (Throwable)ex);
        return StatusDto.buildDataFailureStatusDto((String)ex.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public Object serviceException(Exception ex) {
        this.logger.error("service error", (Throwable)ex);
        return StatusDto.buildDataFailureStatusDto((String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Object exception(Exception ex) {
        this.logger.error("\u5f02\u5e38:", (Throwable)ex);
        return StatusDto.buildDataFailureStatusDto((String)"\u64cd\u4f5c\u5931\u8d25");
    }
}

