/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.quartz;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.service.impl.product.ProductService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class ProductClusterableJob
extends QuartzJobBean {
    private static Logger logger = LoggerFactory.getLogger(ProductClusterableJob.class);
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void executeInternal(JobExecutionContext ctx) throws JobExecutionException {
        ProductService productService = (ProductService)this.applicationContext.getBean(ProductService.class);
        Map config = (Map)this.applicationContext.getBean("timerJobConfig");
        String nodeName = (String)config.get("nodeName");
        List listIds = productService.scheduleList();
        List delistIds = productService.scheduleDelist();
        logger.info("\u4e0a\u4e0b\u67b6\u4efb\u52a1\u7ed3\u675f,\u4e0a\u67b6{}\u4e2a,\u4e0b\u67b6{}\u4e2a\u3002", (Object)listIds.size(), (Object)delistIds.size());
        if (listIds.size() > 0 || delistIds.size() > 0) {
            ArrayList flushProdIds = Lists.newArrayList();
            flushProdIds.addAll(listIds);
            flushProdIds.addAll(delistIds);
        }
    }
}

