/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class AddressRemoteRestController
extends BaseController {
    @Autowired
    private IAddressService addressService;

    @RequestMapping(value={"/addAddress"}, method={RequestMethod.POST})
    public Object add(Address address, Long userId) {
        if (userId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (address == null) {
            return StatusDto.buildFailureStatusDto((String)"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        address.setUser(new User(userId));
        address.setIsDefault(Boolean.valueOf(false));
        this.addressService.insert((Object)address);
        return StatusDto.buildSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/addresses"})
    public Object get(Long userId) {
        if (userId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.addressService.findByUserId(userId);
        Object obj = ObjectFormatUtils.format2Map((Object)list, (String[])new String[]{"id->id", "userId->user.id", "consignee->consignee", "province->province", "address->address", "zipcode->zipcode", "mobile->mobile", "isDefault->isDefault"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f", (Object)obj);
    }

    @RequestMapping(value={"/delAddress"})
    public Object delete(Long id) {
        if (id == null) {
            return StatusDto.buildFailureStatusDto((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.addressService.deleteById(id);
        return StatusDto.buildSuccessStatusDto((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/defaultAddress"})
    public Object setDefault(Long userId, Long id) {
        if (id == null) {
            return StatusDto.buildFailureStatusDto((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (userId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean b = this.addressService.setDefault(userId, id);
        if (!b) {
            return StatusDto.buildFailureStatusDto((String)"\u8bbe\u7f6e\u5931\u8d25");
        }
        return StatusDto.buildSuccessStatusDto((String)"\u8bbe\u7f6e\u6210\u529f");
    }
}

