/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdComment;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.params.CommentRequestParams;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.IProdCommentService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import com.rocoinfo.rocomall.utils.ObjectUtils;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class CommentRemoteRestController
extends BaseController {
    @Autowired
    private IProdCommentService prodCommentService;
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private ISkuService skuService;

    @RequestMapping(value={"/addComment"}, method={RequestMethod.POST})
    public Object add(CommentRequestParams params) {
        if (params == null) {
            return StatusDto.buildFailureStatusDto((String)"\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u63a5\u53e3\u8981\u6c42");
        }
        if (ObjectUtils.isAnyNull((Object[])new Object[]{params.getUserId(), params.getOrderId(), params.getContent(), params.getLevel()})) {
            return StatusDto.buildFailureStatusDto((String)"\u7f3a\u5931\u5fc5\u8981\u53c2\u6570,\u8bf7\u68c0\u67e5\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u7b26\u5408\u8981\u6c42");
        }
        OrderItem item = this.orderItemService.getFirstByOrderId(params.getOrderId());
        if (item == null) {
            return StatusDto.buildFailureStatusDto((String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u8ba2\u5355");
        }
        if (!params.getUserId().equals(item.getUser().getId())) {
            return StatusDto.buildFailureStatusDto((String)"\u8bf7\u786e\u4fdd\u8be5\u7528\u6237\u662f\u6b64\u8ba2\u5355\u7684\u4e0b\u5355\u8005");
        }
        Long skuId = item.getSku() == null ? 0L : item.getSku().getId();
        Long productId = ((Sku)this.skuService.getById(skuId)).getProduct().getId();
        ProdComment com = new ProdComment();
        com.setProduct(new Product(productId));
        com.setContent(params.getContent());
        com.setCreateTime(new Date());
        com.setLevel(params.getLevel());
        com.setOrderItem(item);
        com.setShow(ProdComment.Show.DISPLAY);
        com.setUser(new User(params.getUserId()));
        try {
            item.setStatus(OrderItem.Status.FINISH);
            this.orderItemService.update((Object)item);
            this.prodCommentService.insert((Object)com);
            return StatusDto.buildSuccessStatusDto((String)"\u8bc4\u8bba\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto((String)"\u8bc4\u8bba\u6dfb\u52a0\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/comment"})
    public Object findByProductId(@RequestParam Long productId, @RequestParam(required=false, defaultValue="0") Long page) {
        if (productId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.prodCommentService.findByProductIdScrollPage(productId, page);
        Object obj = ObjectFormatUtils.format2Map((Object)list, (String[])new String[]{"id->id", "name->user.name", "content->content", "level->level", "createTime->createTime"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f", (Object)obj);
    }
}

