/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.params.OrderParams;
import com.rocoinfo.rocomall.service.order.INewOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class OrderRemoteRestController
extends BaseController {
    @Autowired
    private INewOrderService newOrderService;

    @RequestMapping(value={"/createOrder"})
    public Object createOrder(OrderParams orderParams) {
        if (orderParams.getUserId() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderParams.getSkuId() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u8d2d\u4e70\u5546\u54c1skuId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderParams.getQuantity() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u8d2d\u4e70\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderParams.getCost() == null) {
            orderParams.setCost(Double.valueOf(0.0));
        }
        if (orderParams.getIsInvite() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u914d\u9001\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!orderParams.getIsInvite().booleanValue() && orderParams.getAddressId() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237\u6536\u8d27\u5730\u5740Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.newOrderService.createOrder(orderParams);
    }

    @RequestMapping(value={"/payOrder"})
    public Object payOrder(OrderParams orderParams) {
        if (orderParams.getOrderId() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u652f\u4ed8\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderParams.getPaymode() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.newOrderService.payOrder(orderParams);
    }

    @RequestMapping(value={"/orderList"})
    public Object findOrderList(@RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="10") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, Long userId, String status) throws Exception {
        if (userId == null) {
            throw new Exception();
        }
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        return this.newOrderService.findOrderItemList(pageable, userId, status);
    }

    @RequestMapping(value={"/detailsOrder"})
    public Object detailsOrder(Long orderId) {
        return this.newOrderService.details(orderId);
    }

    @RequestMapping(value={"/cancelOrder"})
    public Object cancel(Long orderId, String cancelReason) {
        return this.newOrderService.cancel(orderId, cancelReason);
    }

    @RequestMapping(value={"/deleteOrder"})
    public Object delete(Long orderId) {
        return this.newOrderService.delete(orderId);
    }

    @RequestMapping(value={"/remindShipments"})
    public Object remindShipments(Long orderId) {
        return this.newOrderService.remindShipments(orderId);
    }

    @RequestMapping(value={"/confirmDelivery"})
    public Object confirmDelivery(Long orderId) {
        return this.newOrderService.confirmDelivery(orderId);
    }
}

