/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Description;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.utils.MapUtils;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class ProductRemoteRestController
extends BaseController {
    @Autowired
    private IProductService productService;
    @Autowired
    private IDescriptionService descriptionService;

    @RequestMapping(value={"/products"})
    public Object list(@RequestParam(required=false) Product.ShowStatus client, @RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="0") int page) {
        HashMap params = Maps.newHashMap();
        MapUtils.putNotNull((Map)params, (String)"showStatus", (Object)client);
        MapUtils.putNotNull((Map)params, (String)"keyword", (Object)keyword);
        List list = this.productService.searchWithMainImg((Map)params, page);
        Object obj = ObjectFormatUtils.format2Map((Object)list, (String[])new String[]{"id->id", "name->name", "promotionWord->promotionWord", "price->cashAmt", "image->mainImage.path"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f", (Object)obj);
    }

    @RequestMapping(value={"/product"})
    public Object get(Long productId) {
        if (productId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Product product = (Product)this.productService.getById(productId);
        if (product == null) {
            return StatusDto.buildFailureStatusDto((String)"\u67e5\u8be2\u4e0d\u5230\u6b64\u5546\u54c1");
        }
        this.productService.buildDetail(product);
        Object prodObj = ObjectFormatUtils.format2Map((Object)product, (String[])new String[]{"id->id", "name->name", "promotionWord->promotionWord"});
        if (prodObj instanceof HashMap) {
            Object skuObj;
            HashMap prodMap = (HashMap)prodObj;
            if (CollectionUtils.isNotEmpty((Collection)product.getSkus())) {
                skuObj = ObjectFormatUtils.format2Map((Object)product.getSkus(), (String[])new String[]{"id->id", "code->code", "name->name", "attribute1->attribute1", "attribute2->attribute2", "attribute3->attribute2", "availableStockQuantity->availableStockQuantity", "cashAmt->cashAmt", "attributes->attributes"});
                prodMap.put("skus", skuObj);
            }
            if (CollectionUtils.isNotEmpty((Collection)product.getProductImages())) {
                skuObj = ObjectFormatUtils.format2Map((Object)product.getProductImages(), (String[])new String[]{"id->id", "imageType->imageType", "imageUrl->path"});
                prodMap.put("productImages", skuObj);
            }
        }
        return StatusDto.buildDataSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f", (Object)prodObj);
    }

    @RequestMapping(value={"/description"})
    public Object description(Long productId) {
        if (productId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Description description = this.descriptionService.findByProductId(productId);
        Object obj = ObjectFormatUtils.format2Map((Object)description, (String[])new String[]{"introduction->introduction", "specification->specification"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f", (Object)obj);
    }
}

