/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.utils.RandomTools;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class SmsRemoteRestController
extends BaseController {
    @Autowired
    private JedisTemplate jedisTemplate;

    @RequestMapping(value={"/sms"})
    public Object send(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return StatusDto.buildFailureStatusDto((String)"\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sendSmsCode(mobile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusDto sendSmsCode(String mobilePhone) {
        Session session = WebUtils.getSession();
        if (this.isAllowedSendSms(session, mobilePhone)) {
            Session session2 = session;
            synchronized (session2) {
                if (this.isAllowedSendSms(session, mobilePhone)) {
                    session.setAttribute((Object)"registerSmsCodeTimestamp", (Object)System.currentTimeMillis());
                    session.setAttribute((Object)"registerVcodeMobilePhone", (Object)mobilePhone);
                    String smsCode = RandomTools.getRandStr((int)4, (int)2);
                    smsCode = "1234";
                    this.logger.debug("\u53d1\u9001\u9a8c\u8bc1\u7801 {} \u5230 {}", (Object)smsCode, (Object)mobilePhone);
                    String patten = "content";
                    String smsContent = String.format(patten, smsCode);
                    boolean success = true;
                    session.setAttribute((Object)"vcode", (Object)smsCode);
                    session.setAttribute((Object)"codeWrongCount", (Object)0);
                    this.jedisTemplate.setex("'cache.smssendtime.'+" + mobilePhone, smsCode, 60);
                    if (success) {
                        return StatusDto.buildSuccessStatusDto();
                    }
                    return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                }
                return StatusDto.buildFailureStatusDto((String)"\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41,\u8bf71\u5206\u949f\u540e\u518d\u8bd5!");
            }
        }
        return StatusDto.buildFailureStatusDto((String)"\u60a8\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41,\u8bf71\u5206\u949f\u540e\u518d\u8bd5!");
    }

    private boolean isAllowedSendSms(Session session, String mobilePhone) {
        Long time = (Long)session.getAttribute((Object)"registerSmsCodeTimestamp");
        String smsCode = this.jedisTemplate.get("'cache.smssendtime.'+" + mobilePhone);
        if (StringUtils.isNotBlank((CharSequence)smsCode)) {
            return false;
        }
        return time == null || System.currentTimeMillis() - time > 60000L;
    }
}

