/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.Account;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import com.rocoinfo.rocomall.utils.PasswordUtil;
import com.rocoinfo.rocomall.utils.RandomTools;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remote"})
public class UserRemoteRestController
extends BaseController {
    @Autowired
    private IUserService userService;

    @RequestMapping(value={"/register"}, method={RequestMethod.POST})
    public Object register(User user, String verifyCode) {
        StatusDto validation = this.validateRequestParam(user, verifyCode);
        if ("0".equals(validation.getCode())) {
            return validation;
        }
        if (this.userService.getByUsername(user.getMobile()) != null) {
            return StatusDto.buildFailureStatusDto((String)"\u624b\u673a\u53f7\u5df2\u7ecf\u88ab\u6ce8\u518c");
        }
        user.setUsername(user.getMobile());
        user.setPlainPassword(user.getPassword());
        if (StringUtils.isBlank((CharSequence)user.getName())) {
            user.setName("_\u7528\u6237_" + RandomTools.getRandStr((int)6, (int)0));
        }
        StatusDto res = this.userService.register(user);
        return res;
    }

    @RequestMapping(value={"/changePwd"}, method={RequestMethod.POST})
    public Object changePassword(User user, String verifyCode) {
        StatusDto validation = this.validateRequestParam(user, verifyCode);
        if ("0".equals(validation.getCode())) {
            return validation;
        }
        User original = this.userService.getByUsername(user.getMobile());
        original.setPlainPassword(user.getPassword());
        PasswordUtil.entryptPassword((Account)original);
        this.userService.update((Object)original);
        return StatusDto.buildSuccessStatusDto((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/userInfo"})
    public Object getUserInfo(Long userId) {
        if (userId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = (User)this.userService.getById(userId);
        if (user == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7cfb\u7edf\u65e0\u6b64\u7528\u6237\u4fe1\u606f");
        }
        Object obj = ObjectFormatUtils.format2Map((Object)user, (String[])new String[]{"id->id", "name->name", "gender->gender", "idCard->idCard", "birthday->birthday", "mobile->mobilePhone", "imgUrl ->imgUrl"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u767b\u5f55\u6210\u529f", (Object)obj);
    }

    @RequestMapping(value={"/updateUser"})
    public Object update(User user) {
        if (user == null || user.getId() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237\u4fe1\u606f\u6216\u8005\u7528\u6237id\u4e3a\u7a7a");
        }
        user.setUsername(null);
        user.setMobilePhone(null);
        user.setPassword(null);
        user.setSalt(null);
        this.userService.update((Object)user);
        User userInfo = (User)this.userService.getById(user.getId());
        Object obj = ObjectFormatUtils.format2Map((Object)userInfo, (String[])new String[]{"id->id", "name->name", "gender->gender", "idCard->idCard", "birthday->birthday", "mobile->mobilePhone", "imgUrl ->imgUrl"});
        return StatusDto.buildDataSuccessStatusDto((String)"\u767b\u5f55\u6210\u529f", (Object)obj);
    }

    private StatusDto validateRequestParam(User user, String verifyCode) {
        if (user == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237\u4fe1\u606f\u4e3anull");
        }
        if (StringUtils.isBlank((CharSequence)user.getMobile())) {
            return StatusDto.buildFailureStatusDto((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String password = user.getPassword();
        String confirmPassword = user.getConfirmPassword();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{password, confirmPassword})) {
            return StatusDto.buildFailureStatusDto((String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!password.equals(confirmPassword)) {
            return StatusDto.buildFailureStatusDto((String)"\u5bc6\u7801\u548c\u91cd\u590d\u5bc6\u7801\u4e0d\u76f8\u540c");
        }
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Session session = WebUtils.getSession();
        String sessionMobilePhone = (String)session.getAttribute((Object)"registerVcodeMobilePhone");
        if (sessionMobilePhone == null) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f");
        }
        if (!sessionMobilePhone.equals(user.getMobile())) {
            return StatusDto.buildFailureStatusDto((String)"\u624b\u673a\u53f7\u5fc5\u987b\u662f\u63a5\u6536\u9a8c\u8bc1\u7801\u7684\u624b\u673a\u53f7");
        }
        if (!WebUtils.isSmsVCodeValid((String)verifyCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f");
        }
        return StatusDto.buildSuccessStatusDto();
    }

    @RequestMapping(value={"/bindMobile"})
    public Object bindMobile(@RequestParam Long userId, @RequestParam String mobile, @RequestParam String verifyCode) {
        if (userId == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237id\u4e0d\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return StatusDto.buildFailureStatusDto((String)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)verifyCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Session session = WebUtils.getSession();
        String sessionMobilePhone = (String)session.getAttribute((Object)"registerVcodeMobilePhone");
        if (sessionMobilePhone == null) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f");
        }
        if (!WebUtils.isSmsVCodeValid((String)verifyCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u8fc7\u671f");
        }
        User user = new User(userId);
        user.setMobilePhone(mobile);
        user.setUsername(mobile);
        this.userService.update((Object)user);
        return StatusDto.buildSuccessStatusDto((String)"\u7528\u6237\u7ed1\u5b9a\u624b\u673a\u6210\u529f");
    }
}

