/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest;

import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.utils.WebUtils;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class RestExceptionHandler
extends ResponseEntityExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(RestExceptionHandler.class);

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<?> handleIllegalArgumentException(IllegalArgumentException e) {
        return WebUtils.response400((String)e.getMessage());
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResponseEntity<?> handleServiceException(ServiceException e) {
        return WebUtils.response400((String)e.getMessage());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResponseEntity<?> handle(DuplicateKeyException e) {
        this.logger.warn("DuplicateKeyException", (Throwable)e);
        return WebUtils.response400((String)"DuplicateKeyException");
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<?> handle(ConstraintViolationException ex, WebRequest request) {
        this.logger.warn("ConstraintViolationException", (Throwable)ex);
        return WebUtils.response400((String)ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<?> handle(Exception e) {
        this.logger.warn("Exception", (Throwable)e);
        return WebUtils.response500((String)"\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.debug("\u67e5\u8be2\u53c2\u6570\u6216\u8bf7\u6c42\u4f53\u5185\u5bb9\u4e0d\u5408\u6cd5", (Throwable)ex);
        return WebUtils.response400((String)"\u67e5\u8be2\u53c2\u6570\u6216\u8bf7\u6c42\u4f53\u5185\u5bb9\u4e0d\u5408\u6cd5");
    }

    protected ResponseEntity<Object> handleHttpRequestMethodNotSupported(HttpRequestMethodNotSupportedException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.debug("\u4e0d\u652f\u6301\u8bf7\u6c42\u65b9\u6cd5", (Throwable)ex);
        return WebUtils.response400((String)"\u4e0d\u652f\u6301\u8bf7\u6c42\u65b9\u6cd5");
    }

    protected ResponseEntity<Object> handleHttpMessageNotWritable(HttpMessageNotWritableException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        this.logger.warn("\u8f93\u51fa\u54cd\u5e94\u5185\u5bb9\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)ex);
        return WebUtils.response500((String)"\u8f93\u51fa\u54cd\u5e94\u5185\u5bb9\u65f6\u53d1\u751f\u9519\u8bef");
    }
}

