/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.MutipleDataStatusDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.utils.ExcelUtil;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/upload"})
public class UploadRestController
extends BaseController {
    @Autowired
    private IUploadService uploadService;

    @RequestMapping(method={RequestMethod.POST})
    public Object upload(HttpServletRequest req, HttpServletResponse response, MultipartFile file, @RequestParam UploadService.UploadCategory type) {
        try {
            MutipleDataStatusDto dto = MutipleDataStatusDto.buildSuccessMutipleDataDto();
            String fileUrl = PropertyHolder.getImageBaseUrl() + this.uploadService.upload(file, type);
            String baseUrl = req.getRequestURL().toString();
            dto.setSomeData("fullPath", (Object)(baseUrl.replace(req.getServletPath(), "") + fileUrl));
            dto.setSomeData("path", (Object)fileUrl);
            return dto;
        }
        catch (Exception e) {
            e.printStackTrace();
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/validateExcel"}, method={RequestMethod.GET})
    public Object validateExcel(String path) {
        try {
            File file = this.uploadService.getFileByPath(path);
            if (!file.exists()) {
                return StatusDto.buildDataFailureStatusDto((String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            UploadService.UploadCategory category = this.uploadService.parseCatalogType(path);
            if (!category.getPath().toLowerCase().endsWith("import")) {
                return StatusDto.buildDataFailureStatusDto((String)"\u4e0d\u662fexcel\u7c7b\u578b");
            }
            if (category.getClassName() == null) {
                return StatusDto.buildDataFailureStatusDto((String)"\u540e\u53f0\u7c7b\u578b\u6570\u636e\u914d\u7f6e\u4e0d\u5168");
            }
            ExcelUtil.getInstance().readExcel2ObjsByFile(file, ClassUtil.findClass((String)category.getClassName()));
            return StatusDto.buildDataSuccessStatusDto((String)"\u6587\u4ef6\u9a8c\u8bc1\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
    }
}

