/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Permission;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/adminUser"})
public class AdminUserRestController
extends BaseController {
    @Autowired
    private IAdminUserService adminUserService;
    @Autowired
    private ISupplierService supplierService;

    @RequestMapping(method={RequestMethod.GET})
    public Object search(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) SwitchStatus status) {
        keyword = StringUtils.trimToNull((String)keyword);
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            params.put("keywords", StringUtils.split((String)keyword, (String)" "));
        }
        params.put("status", status);
        Page page = this.adminUserService.searchScrollPage(params, (Pageable)pageRequest);
        List data = (List)ClassToMapUtil.dealSimple((Object)page.getContent(), (String[])new String[]{"id", "username", "name", "status"});
        return new PageTable(data, draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/{id}/switch"}, method={RequestMethod.GET})
    public Object switchStatus(@PathVariable Long id, @RequestParam SwitchStatus status) {
        this.adminUserService.switchAdminStatus(id, status);
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"/{id}"})
    public Object get(@PathVariable Long id) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        if (id > 0L) {
            AdminUser admin = (AdminUser)this.adminUserService.getById(id);
            if (admin != null) {
                this.adminUserService.buildAdminPermissionDetail(admin);
            }
            map.put("admin", admin);
            map.put("allPermissions", Permission.getGroupKeyValuePermissions());
        }
        map.put("roles", this.adminUserService.findAllRole());
        map.put("allSuppliers", this.supplierService.findSuppliers(Boolean.TRUE));
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(map);
        return result;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(@Valid AdminUser adminUser) {
        this.adminUserService.saveAdminAndRole(adminUser);
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"/all"})
    public Object findAll(@RequestParam(required=false) SwitchStatus status) {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        List data = (List)ClassToMapUtil.dealSimple((Object)this.adminUserService.findAllWithStatus(status), (String[])new String[]{"id", "name", "status"});
        result.setData((Object)data);
        return result;
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.POST})
    public Object update(@PathVariable Long id, AdminUser user) {
        if (!user.getId().equals(id)) {
            return StatusDto.buildFailureStatusDto((String)"\u66f4\u65b0\u7ba1\u7406\u5458\u7528\u6237Id\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.adminUserService.updateAdminAndRole(user);
        return StatusDto.buildDataSuccessStatusDto();
    }
}

