/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Adv;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.enumconst.AdvType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.impl.AdvService;
import com.rocoinfo.rocomall.utils.MapUtils;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/banners"})
public class AdvRestController
extends BaseController {
    @Autowired
    private AdvService advService;

    @RequestMapping
    private Object search(@RequestParam(required=false) String keyword, @RequestParam(required=false) AdvType type, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        MapUtils.putNotNull((Map)params, (String)"keyword", (Object)keyword);
        MapUtils.putNotNull((Map)params, (String)"type", (Object)type);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.advService.searchScrollPage((Map)params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/save"})
    public Object save(Adv adv) {
        if (adv != null) {
            adv.setStatus(Status.LOCK);
            adv.setCreateTime(new Date());
            adv.setCreator(new AdminUser(WebUtils.getLoggedUserId()));
            this.advService.insert((IdEntity)adv);
        }
        return StatusDto.buildSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/{id}/get"})
    public Object get(@PathVariable Long id) {
        StatusDto res = StatusDto.buildSuccessStatusDto();
        if (id != null) {
            res.setData((Object)this.advService.getById(id));
        }
        return res;
    }

    @RequestMapping(value={"/update"})
    public Object update(Adv adv) {
        if (adv != null) {
            this.advService.update((IdEntity)adv);
        }
        return StatusDto.buildSuccessStatusDto((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @RequestMapping(value={"/{id}/delete"})
    public Object delete(@PathVariable Long id) {
        if (id != null) {
            Adv adv = (Adv)this.advService.getById(id);
            if (adv != null && Status.LOCK.equals((Object)adv.getStatus())) {
                this.advService.deleteById(id);
            } else {
                return StatusDto.buildFailureStatusDto((String)"\u53ea\u6709\u4e0b\u7ebf\u7684\u5e7f\u544a\u624d\u80fd\u88ab\u5220\u9664!");
            }
        }
        return StatusDto.buildSuccessStatusDto((String)"\u5220\u9664\u6210\u529f!");
    }
}

