/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/choosesku"})
public class ChooseSkuRestController
extends BaseController {
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ICatalogService catalogService;

    @RequestMapping
    public Object query(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Product.Status status) {
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        HashMap<String, List> params = new HashMap<String, List>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keywords", Arrays.asList(keyword.trim().replaceAll(" {2,}", " ").split(" ")));
        }
        params.put("status", (List)status);
        List supplierIds = WebUtils.getWhereClauseSupplierIds(null);
        if (!CollectionUtils.isEmpty((Collection)supplierIds)) {
            params.put("supplierIds", supplierIds);
        }
        Page page = this.skuService.searchScrollPage(params, (Pageable)pageable);
        List data = (List)ClassToMapUtil.dealSimple((Object)page.getContent(), (String[])new String[]{"id", "code", "name", "stock", "status", "cent", "supplierName", "product.listTime", "product.delistTime", "product.status"});
        return new PageTable(data, draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }
}

