/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.utils.QRCodeUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.web.Servlets;

@Controller
@RequestMapping(value={"/qrcode"})
public class QRCodeRestController {
    @RequestMapping(value={"/file"})
    @ResponseBody
    public Object generateQRCode(@RequestParam(required=true) String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return StatusDto.buildFailureStatusDto((String)"\u4e8c\u7ef4\u7801\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        String imgPath = QRCodeUtils.generateQRCode((String)content).replaceAll("uploads/", PropertyHolder.getImageBaseUrl());
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData((Object)imgPath);
        return result;
    }

    @RequestMapping(value={"/stream"})
    public void generateQRCode(@RequestParam(required=true) String content, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("image/png");
        Servlets.setNoCacheHeader((HttpServletResponse)response);
        try {
            QRCodeUtils.generateQRCode((String)content, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

