/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.IProductSpecialService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.utils.Collections3;

@RestController
@RequestMapping(value={"/api/rank"})
public class RankRestController
extends BaseController {
    @Autowired
    private IProductSpecialService productSpecialService;
    @Autowired
    private ICatalogService catalogService;

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="display_order") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer typeId, @RequestParam(required=false) Status status) {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        if (typeId != null && typeId != 0) {
            params.put("typeId", typeId);
        }
        if (status != null) {
            params.put("status", (Integer)status);
        }
        Page pageResult = this.productSpecialService.searchScrollPage(params, (Pageable)new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn})));
        List data = (List)ClassToMapUtil.dealSimple((Object)pageResult.getContent(), (String[])new String[]{"id", "displayOrder", "type.id", "sku.name"});
        return new PageTable(data, draw, Integer.valueOf(pageResult.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public Object setProduct(ProductSpecial productSpecial) {
        this.productSpecialService.insert((Object)productSpecial);
        return StatusDto.buildSuccessStatusDto();
    }

    @RequestMapping(value={"/{id}/delete"}, method={RequestMethod.DELETE})
    public Object deleteSettingProduct(@PathVariable Long id) {
        ProductSpecial productSpecial = (ProductSpecial)this.productSpecialService.getById(id);
        if (productSpecial != null) {
            this.productSpecialService.deleteById(id);
        }
        return StatusDto.buildDataSuccessStatusDto((String)"\u5220\u9664\u6210\u529f!");
    }

    @RequestMapping(value={"/{id}"})
    public Object getRank(@PathVariable Long id) {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(this.productSpecialService.getById(id));
        return result;
    }

    @RequestMapping(value={"/suppliers"}, method={RequestMethod.GET})
    public Object findUserSuppliers() {
        return WebUtils.getManagedSuppliersOfLoginUser();
    }

    @RequestMapping(value={"/catalogparents"}, method={RequestMethod.GET})
    public Object findCatalogParents() {
        return this.catalogService.findSubCatalogs(0L, new Catalog.Status[0]);
    }

    @RequestMapping(value={"/checkExist"}, method={RequestMethod.GET})
    public Object checkExist(@RequestParam String productSpecialType, @RequestParam Long skuId) {
        List checkList;
        StatusDto result = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((CharSequence)productSpecialType)) {
            params.put("type", productSpecialType);
        }
        if (null != skuId && skuId != 0L) {
            params.put("skuId", skuId);
        }
        result = Collections3.isNotEmpty((Collection)(checkList = this.productSpecialService.findProdSepecialByParams(params))) ? StatusDto.buildSuccessStatusDto() : StatusDto.buildDataFailureStatusDto();
        return result;
    }
}

