/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.common.QueryDataException;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.Permission;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.IRoleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.utils.Collections3;

@RestController
@RequestMapping(value={"/api/role"})
public class RoleRestController
extends BaseController {
    @Autowired
    private IAdminUserService adminUserService;
    @Autowired
    private IRoleService roleService;

    @RequestMapping
    public Object showAllRoles(@RequestParam(required=true) String draw, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) throws QueryDataException {
        PageTable result = null;
        try {
            Page page;
            List roles;
            PageRequest pageable = new PageRequest(0, 1000, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
            HashMap<String, String> params = new HashMap<String, String>(4);
            if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                params.put("name", keyword);
            }
            if (Collections3.isNotEmpty((Collection)(roles = (page = this.roleService.searchScrollPage(params, (Pageable)pageable)).getContent()))) {
                Map permissionsMap = Permission.convertAllPermissionsToMap();
                List permissions = null;
                ArrayList<String> permissionLabels = null;
                for (Role role : roles) {
                    this.adminUserService.buildRolePermissionDetail(role);
                    permissions = role.getPermissions();
                    if (Collections3.isNotEmpty((Collection)permissions)) {
                        permissionLabels = new ArrayList<String>(permissions.size());
                        for (String permission : permissions) {
                            permissionLabels.add(permissionsMap.get(permission) == null ? "" : ((Permission.Permissions)permissionsMap.get(permission)).getLabel());
                        }
                    }
                    role.setPermissions(permissionLabels);
                }
                result = new PageTable(roles, draw, roles.size());
            } else {
                result = new PageTable(null, draw, 0);
            }
            return result;
        }
        catch (Exception e) {
            throw new QueryDataException((Throwable)e);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(Role role) {
        this.adminUserService.saveRoleAndPermissions(role);
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/delete"}, method={RequestMethod.GET})
    public Object delete(@PathVariable Long id) {
        this.adminUserService.deleteRoleAndPermissionByRoleId(id);
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.POST})
    public Object update(@PathVariable Long id, Role role) {
        role.setId(id);
        this.adminUserService.updateRoleAndPermissions(role);
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"/{id}/edit"}, method={RequestMethod.GET})
    public Object edit(@PathVariable Long id) {
        StatusDto edit = StatusDto.buildDataSuccessStatusDto();
        edit.setData((Object)this.buildRoleInfoIntoModel(id));
        return edit;
    }

    @RequestMapping(value={"/getAllPermission"}, method={RequestMethod.GET})
    public Object getAllPermission() {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)Permission.getGroupKeyValuePermissions());
        return result;
    }

    private Map buildRoleInfoIntoModel(Long id) {
        HashMap<String, Object> roleInfo = new HashMap<String, Object>(2);
        Role role = null;
        if (id > 0L) {
            role = this.adminUserService.getRoleById(id);
            if (role != null) {
                this.adminUserService.buildRolePermissionDetail(role);
            }
            roleInfo.put("role", role);
            roleInfo.put("allPermissions", Permission.getHasPermissionGroupKeyValuePermissions((List)role.getPermissions()));
        } else {
            roleInfo.put("allPermissions", Permission.getGroupKeyValuePermissions());
        }
        return roleInfo;
    }
}

