/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.ILoginLogService;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentConsumeRecordService;
import com.rocoinfo.rocomall.service.cent.ICentsService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/user"})
public class UserRestController
extends BaseController {
    @Autowired
    private IUserService userService;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private ICentsService centsService;
    @Autowired
    private ICentConsumeRecordService centConsumeRecordService;
    @Autowired
    private ILoginLogService loginLogService;

    @RequestMapping(method={RequestMethod.GET})
    public Object search(@RequestParam(required=false) Date registStartDate, @RequestParam(required=false) Date registEndDate, @RequestParam(required=false) String keyword, @RequestParam(required=false) SwitchStatus status, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap params = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            WebUtils.setObjectValue(params, (String)"keyword", (Object)keyword);
        }
        WebUtils.setObjectValue(params, (String)"status", (Object)status);
        WebUtils.setObjectValue(params, (String)"registStartDate", (Object)registStartDate);
        WebUtils.setObjectValue(params, (String)"registEndDate", (Object)registEndDate);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.userService.searchScrollPage(params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    public Object get(@PathVariable(value="id") Long id) {
        StatusDto dto = StatusDto.buildDataSuccessStatusDto();
        User user = (User)this.userService.getById(id);
        if (user == null) {
            return StatusDto.buildDataFailureStatusDto((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        dto.setData((Object)user);
        return dto;
    }

    @RequestMapping(value={"/{id}/switch"}, method={RequestMethod.GET})
    @ResponseBody
    public Object switchStatus(@PathVariable Long id, @RequestParam SwitchStatus status) {
        User user = new User();
        user.setId(id);
        user.setStatus(status);
        this.userService.update((Object)user);
        return StatusDto.buildSuccessStatusDto();
    }

    @RequestMapping(value={"/username/{username}"}, method={RequestMethod.GET})
    public Object getByUserName(@PathVariable String username) {
        StatusDto result = new StatusDto();
        User user = this.userService.getUserByUsername(username);
        if (user == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        result.setData((Object)user);
        return result;
    }
}

