/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.impl.product.SkuService;
import com.rocoinfo.rocomall.service.order.IDistributionOrderService;
import com.rocoinfo.rocomall.service.order.IOrderDeliveryService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/errorOrder"})
public class AbnormalOrderRestController
extends BaseController {
    private static final int OCCUPYSTOCK_REALSE = 1;
    private static final int OCCUPYLOCK_OCCUPED = 2;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IOrderDeliveryService orderDeliverService;
    @Autowired
    private SkuService skuService;
    @Autowired
    private IDistributionOrderService distributeService;

    @RequestMapping(value={"/switchLock/{orderId}"})
    public Object lockOrUnlockOrder(@PathVariable Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildFailureStatusDto((String)"\u9501\u5b9a/\u89e3\u9501\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (Order.CheckState.NORMAL.equals((Object)order.getCheckState())) {
            return StatusDto.buildFailureStatusDto((String)"\u6b63\u5e38\u8ba2\u5355\u4e0d\u80fd\u505a\u201c\u9501\u5b9a/\u89e3\u9501\u201d\u64cd\u4f5c");
        }
        if (order.getLocked().booleanValue()) {
            Order unlockOrder = new Order();
            unlockOrder.setId(orderId);
            unlockOrder.setLocked(Boolean.FALSE);
            this.orderService.update((Object)unlockOrder);
            OrderItem updateItemStatus = new OrderItem();
            updateItemStatus.setAdmStatus(OrderItem.AdmStatus.EXCEPTION);
            updateItemStatus.setOrder(unlockOrder);
            this.orderItemService.update((Object)updateItemStatus);
            return StatusDto.buildSuccessStatusDto((String)"\u89e3\u9501\u6210\u529f");
        }
        String tipMsg = "\u9501\u5b9a\u6210\u529f";
        if (!order.getClickedLockBtn().booleanValue()) {
            tipMsg = tipMsg + "\u5e76\u91ca\u653e\u5360\u7528\u5e93\u5b58";
            this.orderService.releaseOrOccupyStockByOrderId(orderId, 1);
        }
        Order lockOrder = new Order();
        lockOrder.setId(orderId);
        lockOrder.setClickedLockBtn(Boolean.TRUE);
        lockOrder.setLocked(Boolean.TRUE);
        this.orderService.update((Object)lockOrder);
        OrderItem updateItemStatus = new OrderItem();
        updateItemStatus.setAdmStatus(OrderItem.AdmStatus.LOCKED);
        updateItemStatus.setOrder(lockOrder);
        this.orderItemService.update((Object)updateItemStatus);
        return StatusDto.buildSuccessStatusDto((String)tipMsg);
    }

    @RequestMapping(value={"/pass/{orderId}"})
    public Object auditPass(@PathVariable Long orderId) {
        return this.executePass(orderId);
    }

    @RequestMapping(value={"/cancel/{orderId}"})
    public Object cancel(@PathVariable Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildFailureStatusDto((String)"\u8981\u53d6\u6d88\u7684\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (order.getLocked().booleanValue()) {
            return StatusDto.buildFailureStatusDto((String)"\u8ba2\u5355\u88ab\u9501\u5b9a\uff0c\u4e0d\u80fd\u53d6\u6d88");
        }
        boolean isReleaseOccupedStock = false;
        String msg = "\u8ba2\u5355\u53d6\u6d88\u6210\u529f";
        if (!order.getClickedLockBtn().booleanValue()) {
            isReleaseOccupedStock = true;
            msg = msg + ",\u5e76\u91ca\u653e\u5360\u7528\u5e93\u5b58";
        }
        this.orderItemService.cancelOrder(orderId.longValue(), WebUtils.getLoggedUserId(), isReleaseOccupedStock);
        return StatusDto.buildSuccessStatusDto((String)msg);
    }

    @RequestMapping(value={"/{orderId}"})
    public Object get(@PathVariable Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildFailureStatusDto((String)("\u8ba2\u5355\u4e0d\u5b58\u5728,orderId:" + orderId));
        }
        order.setUser((User)this.userService.getById(order.getUser().getId()));
        order.setDelivery(this.orderDeliverService.getByOrderId(orderId.longValue()));
        return order;
    }

    @RequestMapping(value={"/editSave"})
    public Object edit(OrderDelivery delivery) {
        if (delivery == null || delivery.getId() < 1L) {
            return StatusDto.buildFailureStatusDto((String)"\u6536\u83b7\u5730\u5740\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        this.orderDeliverService.update((Object)delivery);
        return StatusDto.buildSuccessStatusDto((String)"\u6536\u83b7\u5730\u5740\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/editPass"})
    public Object editAndPass(OrderDelivery delivery) {
        if (delivery == null || delivery.getId() < 1L || delivery.getOrderId() < 1L) {
            return StatusDto.buildFailureStatusDto((String)"\u53c2\u6570id\u4e0d\u5408\u6cd5");
        }
        if (!this.orderDeliverService.isValid(delivery)) {
            return StatusDto.buildFailureStatusDto((String)"\u6536\u8d27\u4eba\u6216\u6536\u8d27\u5730\u5740\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u5bfc\u81f4\u8ba2\u5355\u4e3a\u5f02\u5e38\u8ba2\u5355");
        }
        this.orderDeliverService.update((Object)delivery);
        return this.executePass(delivery.getOrderId());
    }

    private Object executePass(Long orderId) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            return StatusDto.buildFailureStatusDto((String)("\u8ba2\u5355\u4e0d\u5b58\u5728\u3002orderId:" + orderId));
        }
        if (order.getLocked().booleanValue()) {
            return StatusDto.buildFailureStatusDto((String)"\u8ba2\u5355\u5df2\u88ab\u9501\u5b9a,\u4e0d\u80fd\u901a\u8fc7");
        }
        List orderItems = this.orderItemService.findByOrderId(orderId);
        if (order.getClickedLockBtn().booleanValue()) {
            ArrayList skuIds = Lists.newArrayList();
            HashMap skuQtyMap = Maps.newHashMap();
            for (OrderItem item : orderItems) {
                skuQtyMap.put(item.getSku().getId(), item.getQuantity());
                skuIds.add(item.getSku().getId());
            }
            List skuList = this.skuService.findByIdIn((List)skuIds);
            for (Sku sku : skuList) {
                if (sku.getAvailableStockQuantity() >= (Integer)skuQtyMap.get(sku.getId())) continue;
                String error = "\u5546\u54c1\uff1a" + sku.getName() + "\u53ef\u552e\u5e93\u5b58\u4e0d\u8db3,\u4e0d\u80fd\u901a\u8fc7! \u5e93\u5b58\u5269\u4f59\uff1a" + sku.getAvailableStockQuantity() + "\u4ef6";
                return StatusDto.buildFailureStatusDto((String)error);
            }
            this.orderService.releaseOrOccupyStockByOrderId(orderId, 2);
        }
        Order passOrder = new Order();
        passOrder.setCheckState(Order.CheckState.NORMAL);
        passOrder.setDistributed(Boolean.TRUE);
        passOrder.setId(order.getId());
        this.orderService.update((Object)passOrder);
        if (!order.getDistributed().booleanValue()) {
            order.setItems(orderItems);
            this.distributeService.generateDistributeOrder(order);
        }
        return StatusDto.buildSuccessStatusDto((String)"\u5f02\u5e38\u8ba2\u5355\u5ba1\u6838\u901a\u8fc7");
    }
}

