/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.DistributeOrderExportToExcelDto;
import com.rocoinfo.rocomall.dto.admin.LogisticInfo;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.DistributionOrder;
import com.rocoinfo.rocomall.entity.order.MergeDistributeOrder;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import com.rocoinfo.rocomall.service.order.IDistributionOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.utils.ExcelMergeRegion;
import com.rocoinfo.rocomall.utils.ExcelUtil;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/distributeOrder"})
public class DistributionOrderRestController
extends BaseController {
    @Autowired
    private IDistributionOrderService distributeOrderService;
    @Autowired
    private IDictExpressService expressService;
    @Autowired
    private IUploadService uploadService;
    @Autowired
    private IDictWarehouseService wareHouseService;
    @Autowired
    private IOrderItemService orderItemService;

    @RequestMapping(method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) Long expressId, @RequestParam(required=false) Boolean exported, @RequestParam(required=false) Boolean merged) {
        HashMap searchParams = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            searchParams.put("keyword", keyword.trim());
        }
        if (startDate != null) {
            searchParams.put("startDate", startDate);
        }
        if (endDate != null) {
            searchParams.put("endDate", endDate);
        }
        if (expressId != null) {
            searchParams.put("expressId", expressId);
        }
        if (exported != null) {
            searchParams.put("exported", exported);
        }
        if (merged != null) {
            searchParams.put("merged", merged);
        }
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = null;
        page = this.distributeOrderService.searchScrollPage((Map)searchParams, (Pageable)pageable);
        this.buildDictData(page.getContent());
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"mergeList"}, method={RequestMethod.GET})
    public Object mergeList(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(required=false) String keyword, @RequestParam(required=false) Long expressId) {
        HashMap searchParams = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            searchParams.put("keyword", keyword.trim());
        }
        if (expressId != null) {
            searchParams.put("expressId", expressId);
        }
        PageRequest pageable = new PageRequest(start, length);
        Page page = null;
        page = this.distributeOrderService.searchMergeDistributeOrder((Map)searchParams, (Pageable)pageable);
        this.buildMergeOrderDictData(page.getContent());
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public void export(@RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) Long expressId, @RequestParam(required=false) Boolean isDistributeExport, HttpServletResponse response) {
        HashMap searchParams = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            searchParams.put("keyword", keyword.trim());
        }
        if (startDate != null) {
            searchParams.put("startDate", startDate);
        }
        if (endDate != null) {
            searchParams.put("endDate", endDate);
        }
        if (expressId != null) {
            searchParams.put("expressId", expressId);
        }
        if (Boolean.TRUE.equals(isDistributeExport)) {
            searchParams.put("exported", Boolean.FALSE);
        }
        int start = 0;
        int maxLength = 5000;
        String orderColumn = "merge_code";
        PageRequest pageable = new PageRequest(start, maxLength, new Sort(Sort.Direction.DESC, new String[]{"merge_code"}));
        Page page = this.distributeOrderService.searchScrollPage((Map)searchParams, (Pageable)pageable);
        List distriOrderList = page.getContent();
        this.buildDictData(distriOrderList);
        ArrayList exportDataList = Lists.newArrayList();
        ExcelMergeRegion[] mergeRanges = null;
        if (CollectionUtils.isNotEmpty((Collection)distriOrderList)) {
            LinkedHashMap mergeRangeMap = Maps.newLinkedHashMap();
            int mergeColIndex = 2;
            for (int rowIdx = 1; rowIdx <= distriOrderList.size(); ++rowIdx) {
                DistributionOrder distriOrder = (DistributionOrder)distriOrderList.get(rowIdx - 1);
                DistributeOrderExportToExcelDto toExcel = new DistributeOrderExportToExcelDto();
                String mergeCode = StringUtils.trimToEmpty((String)distriOrder.getMergeCode());
                if (!mergeCode.isEmpty()) {
                    ExcelMergeRegion region = (ExcelMergeRegion)mergeRangeMap.get(mergeCode);
                    if (region == null) {
                        region = new ExcelMergeRegion();
                        region.setFirstCol(2);
                        region.setLastCol(2);
                        region.setFirstRow(rowIdx);
                        region.setLastRow(rowIdx);
                        mergeRangeMap.put(mergeCode, region);
                    } else {
                        int lastRowIndex = region.getLastRow();
                        region.setLastRow(++lastRowIndex);
                    }
                }
                toExcel.setMergeCode(mergeCode);
                OrderItem item = distriOrder.getOrderItem();
                OrderDelivery delivery = item.getOrder().getDelivery();
                String address = delivery.getAddrPrefix() + delivery.getAddrDetail();
                toExcel.setAddress(address);
                toExcel.setDistriOrderCode(distriOrder.getCode());
                toExcel.setPostcode(delivery.getPostcode());
                toExcel.setRecipient(delivery.getRecipient());
                toExcel.setRecipientPhone(delivery.getRecipientPhone());
                if (distriOrder.hasExpress()) {
                    toExcel.setExpressName(distriOrder.getExpress().getName());
                }
                toExcel.setOrderCreateTime(DateFormatUtils.format((Date)item.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                toExcel.setOrderItemCode(item.getOrderCode());
                toExcel.setQuantity(String.valueOf(item.getQuantity()));
                toExcel.setSkuCode(item.getSku().getCode());
                toExcel.setSkuName(item.getProductName());
                toExcel.setWareHouseName(item.getWareHouse().getName());
                exportDataList.add(toExcel);
            }
            if (MapUtils.isNotEmpty((Map)mergeRangeMap)) {
                mergeRanges = new ExcelMergeRegion[mergeRangeMap.size()];
                Iterator iter = mergeRangeMap.values().iterator();
                int idx = 0;
                while (iter.hasNext()) {
                    mergeRanges[idx] = (ExcelMergeRegion)iter.next();
                    ++idx;
                }
            }
        }
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("content-disposition", "attachment;filename=distributeOrder.xls");
            ExcelUtil.getInstance().exportObj2Excel((OutputStream)response.getOutputStream(), (List)exportDataList, DistributeOrderExportToExcelDto.class, false, mergeRanges);
            if (Boolean.TRUE.equals(isDistributeExport)) {
                this.distributeOrderService.generateOutstoreOrder(distriOrderList, WebUtils.getLoggedUserId());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/downloadLogistic"}, method={RequestMethod.GET})
    public void downloadLogisticTemplate(HttpServletResponse response) {
        String templateFileName = "logistic_template.xls";
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=logistic_template.xls");
        String templateClassPath = "template/logistic_template.xls";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(templateClassPath);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    @RequestMapping(value={"importLogistic"}, method={RequestMethod.POST})
    public Object importLogisticInfo(@RequestParam(required=true) String filePath) {
        File file = this.uploadService.submitPathAndGetfile(filePath);
        if (!this.isExcelFile(file)) {
            return StatusDto.buildFailureStatusDto((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u9009\u62e9Excel\u6587\u4ef6");
        }
        try {
            List logisticList = ExcelUtil.getInstance().readExcel2ObjsByFile(file, LogisticInfo.class);
            if (CollectionUtils.isNotEmpty((Collection)logisticList)) {
                HashSet expressCodeSet = Sets.newHashSet();
                Map expressMap = Maps.newHashMap();
                for (LogisticInfo logis : logisticList) {
                    if (!StringUtils.isNotBlank((CharSequence)logis.getExpressCode())) continue;
                    expressCodeSet.add(logis.getExpressCode().trim());
                }
                if (!expressCodeSet.isEmpty()) {
                    expressMap = this.expressService.findExpressMapByCodesIn((List)Lists.newArrayList(expressCodeSet.iterator()));
                }
                ArrayList updateList = Lists.newArrayList();
                for (LogisticInfo logis : logisticList) {
                    if (StringUtils.isBlank((CharSequence)logis.getDistributeOrderCode())) continue;
                    String distributeOrderCode = logis.getDistributeOrderCode().trim();
                    DistributionOrder update = new DistributionOrder();
                    update.setCode(distributeOrderCode);
                    update.setTransportNo(logis.getTransportNo().trim());
                    DictExpress exp = (DictExpress)expressMap.get(logis.getExpressCode().trim());
                    update.setExpress(exp);
                    updateList.add(update);
                }
                this.distributeOrderService.importLogistics((List)updateList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return StatusDto.buildFailureStatusDto((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9");
        }
        return StatusDto.buildFailureStatusDto((String)"\u7269\u6d41\u5355\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"importSignLogistic"}, method={RequestMethod.POST})
    public Object importSignLogistic(@RequestParam(required=true) String filePath) {
        File file = this.uploadService.submitPathAndGetfile(filePath);
        if (!this.isExcelFile(file)) {
            return StatusDto.buildFailureStatusDto((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u9009\u62e9Excel\u6587\u4ef6");
        }
        try {
            List logisticList = ExcelUtil.getInstance().readExcel2ObjsByFile(file, LogisticInfo.class);
            if (CollectionUtils.isNotEmpty((Collection)logisticList)) {
                ArrayList updateList = Lists.newArrayList();
                for (LogisticInfo logis : logisticList) {
                    if (StringUtils.isBlank((CharSequence)logis.getDistributeOrderCode())) continue;
                    String distributeOrderCode = logis.getDistributeOrderCode().trim();
                    DistributionOrder update = new DistributionOrder();
                    update.setCode(distributeOrderCode);
                    update.setTransportNo(logis.getTransportNo().trim());
                    updateList.add(update);
                }
                this.distributeOrderService.updateOrderItemStatus((List)updateList, OrderItem.Status.FINISH, OrderItem.AdmStatus.FINISH);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return StatusDto.buildFailureStatusDto((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9");
        }
        return StatusDto.buildFailureStatusDto((String)"\u7269\u6d41\u7b7e\u6536\u5355\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"merge"}, method={RequestMethod.GET})
    public Object mergeDistributeOrder(@RequestParam String mergeCode, @RequestParam List<Long> distriOrderIdList) {
        if (StringUtils.isEmpty((CharSequence)mergeCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u5408\u5355\u64cd\u4f5c\uff1amergeCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (distriOrderIdList.size() < 2) {
            return StatusDto.buildFailureStatusDto((String)"\u5408\u5355\uff0c\u53c2\u6570distriOrderIdList\u7684size\u4e0d\u80fd\u5c0f\u4e8e2");
        }
        List distriOrderList = this.distributeOrderService.findDistributeOrderWithItemAddrByIdIn(distriOrderIdList);
        if (distriOrderList.size() < 2) {
            return StatusDto.buildFailureStatusDto((String)"\u4f20\u9012\u7684\u53c2\u6570distriOrderIdList\u6709\u8bef\uff0c\u6ca1\u6709\u627e\u5230\u80fd\u591f\u5408\u5e76\u7684\u914d\u9001\u5355\u8bb0\u5f55");
        }
        DistributionOrder firstDistriOrder = (DistributionOrder)distriOrderList.get(0);
        for (int i = 0; i < distriOrderList.size(); ++i) {
            DistributionOrder destOrder = (DistributionOrder)distriOrderList.get(i);
            if (destOrder.getExported().booleanValue()) {
                return StatusDto.buildFailureStatusDto((String)("\u914d\u9001\u5355(" + destOrder.getCode() + ")\u72b6\u6001\u662f\u201c\u5df2\u914d\u9001\u5bfc\u51fa\u201d,\u4e0d\u80fd\u505a\u5408\u5e76\u64cd\u4f5c\u3002"));
            }
            if (!destOrder.hasExpress()) {
                return StatusDto.buildFailureStatusDto((String)("\u914d\u9001\u5355(" + destOrder.getCode() + ")\u8fd8\u6ca1\u6709\u5bfc\u5165\u7269\u6d41\u4fe1\u606f,\u4e0d\u80fd\u505a\u5408\u5e76\u64cd\u4f5c\u3002"));
            }
            if (i < 1) continue;
            if (!destOrder.getExpress().getId().equals(firstDistriOrder.getExpress().getId())) {
                return StatusDto.buildFailureStatusDto((String)("\u914d\u9001\u5355(" + destOrder.getCode() + ")\u5feb\u9012\u516c\u53f8\u4e0d\u540c,\u4e0d\u80fd\u505a\u5408\u5e76\u64cd\u4f5c\u3002"));
            }
            if (!destOrder.getOrderItem().getWareHouse().getId().equals(firstDistriOrder.getOrderItem().getWareHouse().getId())) {
                return StatusDto.buildFailureStatusDto((String)("\u914d\u9001\u5355(" + destOrder.getCode() + ")\u5173\u8054\u8ba2\u5355Item\u7684\u4ed3\u5e93\u4e0d\u540c,\u4e0d\u80fd\u505a\u5408\u5e76\u64cd\u4f5c\u3002"));
            }
            if (this.isSameDelivery(firstDistriOrder, destOrder)) continue;
            return StatusDto.buildFailureStatusDto((String)("\u914d\u9001\u5355(" + destOrder.getCode() + ")\u7684\u6536\u83b7\u5730\u5740\u4fe1\u606f\u4e0d\u540c,\u4e0d\u80fd\u505a\u5408\u5e76\u64cd\u4f5c\u3002"));
        }
        this.distributeOrderService.mergeOrSplit(distriOrderIdList, mergeCode);
        return StatusDto.buildSuccessStatusDto((String)"\u914d\u9001\u5355\u5408\u5e76\u6210\u529f");
    }

    @RequestMapping(value={"mergeUI"}, method={RequestMethod.GET})
    public Object mergeUIDistriOrders(@RequestParam List<Long> distriOrderIdList) {
        if (CollectionUtils.isEmpty(distriOrderIdList) || distriOrderIdList.size() < 2) {
            return StatusDto.buildFailureStatusDto((String)"\u53c2\u6570distriOrderIdList\u7684size\u4e0d\u80fd\u5c0f\u4e8e2");
        }
        StatusDto statusDto = StatusDto.buildDataSuccessStatusDto();
        List distrOrderList = this.distributeOrderService.findDistributeOrderWithItemAddrByIdIn(distriOrderIdList);
        this.buildDictData(distrOrderList);
        statusDto.setData((Object)distrOrderList);
        return statusDto;
    }

    @RequestMapping(value={"splitUI/{mergeCode}"}, method={RequestMethod.GET})
    public Object splitUIDistriOrders(@PathVariable String mergeCode) {
        if (StringUtils.isEmpty((CharSequence)mergeCode)) {
            return StatusDto.buildFailureStatusDto((String)"\u53c2\u6570mergeCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StatusDto statusDto = StatusDto.buildDataSuccessStatusDto();
        List mergedDistrOrderList = this.distributeOrderService.findDistributeOrderWithItemAddrByIdIn(this.distributeOrderService.findDistributeOrderIdsByMergeCode(mergeCode));
        this.buildDictData(mergedDistrOrderList);
        statusDto.setData((Object)mergedDistrOrderList);
        return statusDto;
    }

    @RequestMapping(value={"split"}, method={RequestMethod.GET})
    public Object splitDistributeOrder(@RequestParam List<Long> distriOrderIdList) {
        if (CollectionUtils.isEmpty(distriOrderIdList) || distriOrderIdList.size() < 2) {
            return StatusDto.buildFailureStatusDto((String)"\u62c6\u5355\uff0c\u53c2\u6570distriOrderIdList\u7684size\u4e0d\u80fd\u5c0f\u4e8e2");
        }
        this.distributeOrderService.mergeOrSplit(distriOrderIdList, "");
        List distributionOrders = this.distributeOrderService.findDistributeOrderWithItemAddrByIdIn(distriOrderIdList);
        if (distributionOrders != null && distributionOrders.size() > 0) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (DistributionOrder order : distributionOrders) {
                ids.add(order.getOrderItem().getId());
            }
            this.orderItemService.batchUpdateStatus(OrderItem.Status.PAID, OrderItem.AdmStatus.DISTRIBUTION_WAIT_OUT, ids);
        }
        return StatusDto.buildSuccessStatusDto((String)"\u62c6\u5355\u6210\u529f");
    }

    private boolean isExcelFile(File file) {
        String extName = FilenameUtils.getExtension((String)file.getName());
        return "xls".equals(extName) || "xlsx".equals(extName);
    }

    private boolean isSameDelivery(DistributionOrder sourceDistrOrder, DistributionOrder targetDistrOrder) {
        OrderDelivery sourceDelivery = sourceDistrOrder.getOrderItem().getOrder().getDelivery();
        OrderDelivery targeDelivery = targetDistrOrder.getOrderItem().getOrder().getDelivery();
        if (sourceDelivery == null) {
            return targeDelivery == null;
        }
        return sourceDelivery.getRecipient().equals(targeDelivery.getRecipient()) && sourceDelivery.getProvince().equals(targeDelivery.getProvince()) && sourceDelivery.getCity().equals(targeDelivery.getCity()) && sourceDelivery.getCounty().equals(targeDelivery.getCounty()) && sourceDelivery.getAddrDetail().equals(targeDelivery.getAddrDetail());
    }

    private void buildMergeOrderDictData(List<MergeDistributeOrder> mergeOrderList) {
        if (CollectionUtils.isNotEmpty(mergeOrderList)) {
            Map wareHouseMap = this.wareHouseService.findAllWarehouseMap();
            Map expressMap = this.expressService.findAllExpressMap();
            for (MergeDistributeOrder mergeOrder : mergeOrderList) {
                if (mergeOrder.getExpress() != null && mergeOrder.getExpress().getId() > 0L) {
                    mergeOrder.setExpress((DictExpress)expressMap.get(mergeOrder.getExpress().getId()));
                }
                mergeOrder.setWareHouse((DictWarehouse)wareHouseMap.get(mergeOrder.getWareHouse().getId()));
            }
        }
    }

    private void buildDictData(List<DistributionOrder> distriOrderList) {
        if (CollectionUtils.isNotEmpty(distriOrderList)) {
            Map wareHouseMap = this.wareHouseService.findAllWarehouseMap();
            Map expressMap = this.expressService.findAllExpressMap();
            for (DistributionOrder distrOrder : distriOrderList) {
                if (distrOrder.hasExpress()) {
                    distrOrder.setExpress((DictExpress)expressMap.get(distrOrder.getExpress().getId()));
                }
                distrOrder.getOrderItem().setWareHouse((DictWarehouse)wareHouseMap.get(distrOrder.getOrderItem().getWareHouse().getId()));
            }
        }
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }
}

