/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.order;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import com.rocoinfo.rocomall.service.impl.product.SkuService;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/instoreOrder"})
public class InstoreOrderRestController
extends BaseController {
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IUserService userService;
    @Autowired
    private SkuService skuService;
    @Autowired
    private IInstoreOrderService instoreOrderService;
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private IDictWarehouseService wareHouseService;

    @RequestMapping(value={""})
    public Object list(@RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) InstoreOrder.InstoreType instoreType, @RequestParam(required=false) InstoreOrder.ReceiveStatus receiveState, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap searchParams = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            searchParams.put("keyword", keyword);
        }
        if (instoreType != null) {
            searchParams.put("instoreType", instoreType);
        }
        if (startDate != null) {
            searchParams.put("startDate", startDate);
        }
        if (endDate != null) {
            searchParams.put("endDate", endDate);
        }
        if (receiveState != null) {
            searchParams.put("receiveState", receiveState);
        }
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.instoreOrderService.searchScrollPage((Map)searchParams, (Pageable)pageable);
        this.buildDictWareHouse(page.getContent());
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/{id}/finish"})
    public Object completeRefund(@PathVariable Long id) {
        InstoreOrder instoreOrder = (InstoreOrder)this.instoreOrderService.getById(id);
        if (instoreOrder == null) {
            return StatusDto.buildFailureStatusDto((String)("\u5165\u5e93\u5355\u4e0d\u5b58\u5728,id:" + id));
        }
        if (InstoreOrder.ReceiveStatus.FINISHED.equals((Object)instoreOrder.getReceiveState())) {
            return StatusDto.buildFailureStatusDto((String)"\u5df2\u786e\u8ba4\u6536\u8d27\u7684\u5165\u5e93\u5355\u65e0\u9700\u518d\u6b21\u786e\u8ba4\u6536\u8d27");
        }
        try {
            this.instoreOrderService.refundConfirmReceive(instoreOrder);
            return StatusDto.buildSuccessStatusDto((String)"\u786e\u8ba4\u6536\u8d27\u6210\u529f");
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)"\u7cfb\u7edf\u5f02\u5e38,\u9000\u8d27\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/purchase"}, method={RequestMethod.POST})
    public Object instore(InstoreOrder instoreOrder) {
        if (instoreOrder == null) {
            return StatusDto.buildFailureStatusDto((String)"\u7cfb\u7edf\u5f02\u5e38,\u5165\u5e93\u5931\u8d25!");
        }
        if (instoreOrder.getSku() == null) {
            return StatusDto.buildFailureStatusDto((String)"\u5165\u5e93\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (instoreOrder.getQuantity() == null || instoreOrder.getQuantity() <= 0) {
            return StatusDto.buildFailureStatusDto((String)"\u5165\u5e93\u6570\u91cf\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570!");
        }
        instoreOrder.setOperator(new AdminUser(WebUtils.getLoggedUserId()));
        instoreOrder.setCode(this.codeGenerator.generateInstoreOrderCode());
        instoreOrder.setInType(InstoreOrder.InstoreType.PURCHASE);
        instoreOrder.setReceiveState(InstoreOrder.ReceiveStatus.FINISHED);
        instoreOrder.setCreateTime(new Date());
        try {
            this.instoreOrderService.insert((Object)instoreOrder);
            return StatusDto.buildSuccessStatusDto((String)"\u5546\u54c1\u5165\u5e93\u6210\u529f!");
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)"\u5165\u5e93\u65f6,\u670d\u52a1\u5668\u53d1\u751f\u9519\u8bef");
        }
    }

    private void buildDictWareHouse(List<InstoreOrder> instoreOrderList) {
        if (CollectionUtils.isNotEmpty(instoreOrderList)) {
            Map wareHouseMap = this.wareHouseService.findAllWarehouseMap();
            for (InstoreOrder instore : instoreOrderList) {
                instore.setWarehouse((DictWarehouse)wareHouseMap.get(instore.getWarehouse().getId()));
            }
        }
    }
}

