/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.order;

import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.rest.admin.order.OrderOutStoreRestController;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/orderOutStore"})
public class OrderOutStoreRestController {
    @Autowired
    private IOrderOutStoreService orderOutStoreService;

    @RequestMapping(method={RequestMethod.GET})
    public Object seach(@RequestParam(required=false) String draw, @RequestParam(required=false) DateType dateType, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) Boolean state) throws ParseException {
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = null;
        page = this.orderOutStoreService.searchScrollPage(this.buildSearchParamMap(dateType, startDate, endDate, state, keyword), (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    private Map<String, Object> buildSearchParamMap(DateType dateType, Date startDate, Date endDate, Boolean state, String keyword) {
        keyword = StringUtils.trimToNull((String)keyword);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (dateType == null) {
            if (startDate != null) {
                params.put("startDate", startDate);
            }
            if (endDate != null) {
                params.put("endDate", endDate);
            }
        } else if (dateType == DateType.NEARLY7DAYS) {
            OrderOutStoreRestController.putDateParams(params, (long)-604800000L, (Long)0L);
        } else if (dateType == DateType.TODAY) {
            OrderOutStoreRestController.putDateParams(params, (long)0L, null);
        } else if (dateType == DateType.YESTERDAY) {
            OrderOutStoreRestController.putDateParams(params, (long)-86400000L, null);
        } else {
            OrderOutStoreRestController.putDateParams(params, (long)0L, null);
        }
        if (state != null) {
            params.put("state", state);
        }
        if (keyword != null) {
            params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator((String)keyword, (String)" ")));
        }
        return params;
    }

    private static void putDateParams(Map<String, Object> params, long time, Long endTime) {
        Date date = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date currDate = new Date(date.getTime() + time);
        String currDateStr = sdf1.format(currDate);
        Date endDateTmp = null;
        try {
            Date startDateTmp = sdf2.parse(currDateStr + " 00:00:00");
            params.put("startDate", startDateTmp);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (endTime == null) {
            try {
                endDateTmp = sdf2.parse(currDateStr + " 23:59:59");
            }
            catch (ParseException parseException) {}
        } else {
            Date endDate = new Date(date.getTime() + endTime);
            try {
                endDateTmp = sdf2.parse(sdf1.format(endDate) + " 23:59:59");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        params.put("endDate", endDateTmp);
    }

    @RequestMapping(value={"/modifyState/{id}"}, method={RequestMethod.POST})
    public Object modifyExpress(Boolean state, @PathVariable Long id) throws Exception {
        try {
            if (id == null) {
                return StatusDto.buildFailureStatusDto((String)"\u51fa\u5e93\u5355id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            OrderOutStore tempOrder = (OrderOutStore)this.orderOutStoreService.getById(id);
            if (tempOrder == null) {
                return StatusDto.buildFailureStatusDto((String)"\u51fa\u5e93\u5355id\u65e0\u6548!");
            }
            OrderOutStore orderOutStore = new OrderOutStore();
            orderOutStore.setId(id);
            orderOutStore.setSku(tempOrder.getSku());
            orderOutStore.setQuantity(tempOrder.getQuantity());
            orderOutStore.setState(state);
            orderOutStore.setOperateDatetime(new Date());
            orderOutStore.setOperator(new AdminUser(WebUtils.getLoggedUserId()));
            this.orderOutStoreService.execOutStore(orderOutStore);
            return StatusDto.buildSuccessStatusDto();
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }
}

