/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.order;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelDto;
import com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelFailDto;
import com.rocoinfo.rocomall.dto.admin.OrderExportExcelDto;
import com.rocoinfo.rocomall.dto.admin.OrderItemExchageRefundParamDto;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderDelivery;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.impl.order.NewOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.utils.ExcelMergeRegion;
import com.rocoinfo.rocomall.utils.ExcelUtil;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/order"})
public class OrderRestController
extends BaseController {
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    public IAddressService addressService;
    @Autowired
    public IDictExpressService expressService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IProductService productService;
    @Autowired
    private IUploadService uploadService;
    @Autowired
    private NewOrderService newOrderService;

    @RequestMapping(method={RequestMethod.GET})
    public Object seach(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) Long supplierId, @RequestParam(required=false) OrderItem.Status status, @RequestParam(required=false) Boolean orderLocked, @RequestParam(required=false) Order.CheckState checkState, @RequestParam(required=false) OrderItem.Group group, @RequestParam(required=false) OrderItem.OrderType orderType, @RequestParam(required=false) OrderItem.AdmStatus admStatus) {
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        List searchSupplierIds = WebUtils.getWhereClauseSupplierIds((Long)supplierId);
        Page page = null;
        page = this.orderItemService.searchScrollPage(this.buildSearchParamMap(searchSupplierIds, startDate, endDate, status, orderLocked, checkState, group, keyword, orderType, admStatus), (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/byCode"}, method={RequestMethod.GET})
    public Object getCanRefundOrderItems(@RequestParam(required=false) String draw, @RequestParam String orderCode) {
        Order order;
        List orderItems = Collections.emptyList();
        if (StringUtils.isNotBlank((CharSequence)orderCode) && (order = this.orderService.getByOrderNo(orderCode)) != null) {
            orderItems = this.orderItemService.findByOrderId(order.getId());
            Iterator it = orderItems.iterator();
            while (it.hasNext()) {
                if (OrderItem.Status.FINISH.equals((Object)((OrderItem)it.next()).getStatus())) continue;
                it.remove();
            }
        }
        return new PageTable(orderItems, draw, orderItems.size());
    }

    private Map<String, Object> buildSearchParamMap(List<Long> paramSupplierIdList, Date startDate, Date endDate, OrderItem.Status status, Boolean orderLocked, Order.CheckState checkState, OrderItem.Group group, String keyword, OrderItem.OrderType orderType, OrderItem.AdmStatus admStatus) {
        keyword = StringUtils.trimToNull((String)keyword);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (CollectionUtils.isNotEmpty(paramSupplierIdList)) {
            params.put("supplierIds", paramSupplierIdList);
        }
        if (startDate != null) {
            params.put("startDate", startDate);
        }
        if (endDate != null) {
            params.put("endDate", endDate);
        }
        if (status != null) {
            params.put("status", status);
        }
        if (checkState != null) {
            params.put("checkState", checkState);
        }
        if (Order.CheckState.EXCEPTION.equals((Object)checkState) && orderLocked != null) {
            params.put("locked", orderLocked);
        }
        if (group != null) {
            params.put("group", group);
        }
        if (keyword != null) {
            params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator((String)keyword, (String)" ")));
        }
        if (orderType != null) {
            params.put("orderType", orderType);
        }
        if (admStatus != null) {
            params.put("admStatus", admStatus);
        }
        return params;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public void export(@RequestParam(required=false) String keyword, @RequestParam(required=false) Date startDate, @RequestParam(required=false) Date endDate, @RequestParam(required=false) Long supplierId, @RequestParam(required=false) OrderItem.Status status, @RequestParam(required=false) Boolean orderLocked, @RequestParam(required=false) Order.CheckState checkState, @RequestParam(required=false) OrderItem.Group group, @RequestParam(required=false) OrderItem.OrderType orderType, @RequestParam(required=false) OrderItem.AdmStatus admStatus, HttpServletResponse response) {
        String orderTemplate = "template/order_template.xls";
        try {
            String orderExcelFileName = URLEncoder.encode("order", "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("content-disposition", "attachment;filename=" + orderExcelFileName + ".xls");
            ArrayList orderExcelDataList = Lists.newArrayList();
            List whereClauseSupplierIds = WebUtils.getWhereClauseSupplierIds((Long)supplierId);
            Map params = this.buildSearchParamMap(whereClauseSupplierIds, startDate, endDate, status, orderLocked, checkState, group, keyword, orderType, admStatus);
            params.put("limitSize", 60000);
            List orderItemList = this.orderItemService.adminExportSearch(params);
            if (CollectionUtils.isNotEmpty((Collection)orderItemList)) {
                ArrayList needToDealedOrderItemIds = Lists.newArrayList();
                StringBuilder addrBuf = new StringBuilder();
                for (OrderItem orderItem : orderItemList) {
                    OrderExportExcelDto orderDto = new OrderExportExcelDto();
                    orderDto.setOrderNo(orderItem.getOrderCode());
                    Sku sku = orderItem.getSku();
                    if (sku != null) {
                        orderDto.setProdCode(sku.getCode());
                    }
                    orderDto.setProdName(orderItem.getProductName());
                    orderDto.setQuantity(orderItem.getQuantity().intValue());
                    orderDto.setStatus(orderItem.getStatus().getLabel());
                    orderDto.setPlaceOrderDateTime(DateFormatUtils.format((Date)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    OrderDelivery addr = orderItem.getOrder().getDelivery();
                    if (addr != null) {
                        orderDto.setReceiverName(addr.getRecipient());
                        orderDto.setReceiverMobile(addr.getRecipientPhone());
                        orderDto.setPostCode(addr.getPostcode());
                        addrBuf.append(addr.getProvince()).append(",").append(addr.getCity()).append(",").append(addr.getCounty()).append(",");
                        addrBuf.append(addr.getAddrDetail());
                        orderDto.setAddress(addrBuf.toString());
                        addrBuf.delete(0, addrBuf.length());
                        if (OrderItem.Status.PAID == orderItem.getStatus()) {
                            needToDealedOrderItemIds.add(orderItem.getId());
                        }
                    }
                    orderExcelDataList.add(orderDto);
                }
                this.orderItemService.dealWithOrderItems(true, new AdminUser(WebUtils.getLoggedUserId()), needToDealedOrderItemIds.toArray(new Long[0]));
            }
            ExcelUtil.getInstance().exportObj2ExcelByTemplate((Map)null, "template/order_template.xls", (OutputStream)response.getOutputStream(), (List)orderExcelDataList, OrderExportExcelDto.class, Boolean.TRUE.booleanValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @RequestMapping(value={"/{orderItemId}"}, method={RequestMethod.GET})
    public Object get(@PathVariable Long orderItemId) {
        OrderItem orderItem = (OrderItem)this.orderItemService.getById(orderItemId);
        this.orderItemService.buildDetail(orderItem);
        List operationLogs = this.orderItemService.findOperationLogByOrderItemId(orderItem.getId());
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("orderItem", orderItem);
        map.put("operationLogs", operationLogs);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(map);
        return result;
    }

    @RequestMapping(value={"/deal/{orderItemId}"}, method={RequestMethod.GET})
    public Object deal(@PathVariable Long orderItemId) {
        OrderItem orderItem = (OrderItem)this.orderItemService.getById(orderItemId);
        this.orderItemService.buildDetail(orderItem);
        this.orderItemService.dealWithOrderItems(false, new AdminUser(WebUtils.getLoggedUserId()), new Long[]{orderItemId});
        return StatusDto.buildSuccessStatusDto((String)"\u8ba2\u5355\u5904\u7406\u6210\u529f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public Object importToSend(@RequestParam(required=true) String filePath, @RequestParam(required=false) UploadService.UploadCategory type, HttpServletResponse response) {
        File file = this.uploadService.submitPathAndGetfile(filePath);
        List sendOrderList = ExcelUtil.getInstance().readExcel2ObjsByFile(file, OrderBitchSendImportExcelDto.class);
        StatusDto result = this.orderItemService.importToSend(sendOrderList, new AdminUser(WebUtils.getLoggedUserId()));
        if (result.isSuccess()) {
            return result;
        }
        Map resMap = (Map)result.getData();
        List canNotUpdateDtos = (List)resMap.get("canNotUpdateDtos");
        List canUpdateDtos = (List)resMap.get("canUpdateDtos");
        response.setContentType("application/vnd.ms-excel");
        try {
            ExcelUtil.getInstance().exportObj2Excel((OutputStream)response.getOutputStream(), canNotUpdateDtos, OrderBitchSendImportExcelFailDto.class, true, new ExcelMergeRegion[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return StatusDto.buildFailureStatusDto();
        }
    }

    @RequestMapping(value={"/send"}, method={RequestMethod.POST})
    public Object send(OrderItem orderItem) {
        try {
            this.orderItemService.sendOrder(orderItem, WebUtils.getLoggedUserId());
        }
        catch (ServiceException ex) {
            return StatusDto.buildFailureStatusDto((String)ex.getMessage());
        }
        return StatusDto.buildSuccessStatusDto((String)"\u53d1\u8d27\u6210\u529f");
    }

    @RequestMapping(value={"/modifyExpress"}, method={RequestMethod.POST})
    public Object modifyExpress(OrderItem orderItem) throws Exception {
        try {
            this.orderItemService.updateExpressAndTransportNoById(orderItem.getExpress().getId().longValue(), orderItem.getTransportNo(), orderItem.getId().longValue());
            return StatusDto.buildSuccessStatusDto();
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)"\u4fdd\u5b58\u5931\u8d25!");
        }
    }

    @RequestMapping(value={"/repeatSend/{orderItemId}"}, method={RequestMethod.GET})
    public Object repeatSend(@PathVariable Long orderItemId) {
        try {
            this.orderItemService.repeatSendOrder(orderItemId.longValue());
        }
        catch (ServiceException ex) {
            return StatusDto.buildFailureStatusDto((String)ex.getMessage());
        }
        return StatusDto.buildSuccessStatusDto((String)"\u91cd\u65b0\u53d1\u8d27\u6210\u529f");
    }

    @RequestMapping(value={"/cancel/{orderItemId}"}, method={RequestMethod.GET})
    public Object cancel(@PathVariable Long orderItemId) {
        OrderItem orderItem = (OrderItem)this.orderItemService.getById(orderItemId);
        this.orderItemService.cancelOrderItem(orderItemId.longValue(), WebUtils.getLoggedUserId());
        return StatusDto.buildSuccessStatusDto((String)"\u8ba2\u5355\u53d6\u6d88\u6210\u529f");
    }

    @RequestMapping(value={"/exchange"}, method={RequestMethod.POST})
    @ResponseBody
    public Object doExchage(@RequestBody OrderItemExchageRefundParamDto exchageParamDto) {
        try {
            this.orderItemService.exchangeSalesOrderItems(exchageParamDto);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
        return StatusDto.buildSuccessStatusDto((String)"\u6362\u8d27\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/refund"}, method={RequestMethod.POST})
    public Object doRefund(@RequestBody OrderItemExchageRefundParamDto refundParamDto) {
        try {
            this.orderItemService.doRefundSalesOrderItems(refundParamDto);
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
        return StatusDto.buildSuccessStatusDto((String)"\u9000\u8d27\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/updateState/{orderItemId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Object updateOrderFinalStatus(@PathVariable Long orderItemId, @RequestParam OrderItem.Status finalState, @RequestParam OrderItem.AdmStatus admStatus) {
        this.orderItemService.updateOrderState(orderItemId.longValue(), finalState, admStatus, WebUtils.getLoggedUserId());
        return StatusDto.buildSuccessStatusDto((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public void downloadSendTemplate(HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=sendTemplate.xls");
        try {
            List emptyList = Collections.emptyList();
            ExcelUtil.getInstance().exportObj2Excel((OutputStream)response.getOutputStream(), emptyList, OrderBitchSendImportExcelDto.class, false, new ExcelMergeRegion[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }
}

