/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.product.IBrandService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/brand"})
public class BrandRestController
extends BaseController {
    @Autowired
    private IBrandService brandService;

    @RequestMapping(method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String keyword, @RequestParam(required=false) Status status, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            WebUtils.setObjectValue((Map)params, (String)"keywords", (Object)StringUtils.split((String)keyword, (String)" "));
        }
        WebUtils.setObjectValue((Map)params, (String)"status", (Object)status);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.brandService.searchScrollPage((Map)params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}"})
    public Object get(@PathVariable Long id) {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(this.brandService.getById(id));
        return result;
    }

    @RequestMapping(value={"/all"})
    public Object findAll() {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)this.brandService.findAll());
        return result;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(Brand brand) {
        brand.setStatus(Status.OPEN);
        this.brandService.insert((Object)brand);
        return StatusDto.buildSuccessStatusDto((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(Brand brand) {
        this.brandService.update((Object)brand);
        return StatusDto.buildSuccessStatusDto((String)"\u66f4\u65b0\u6210\u529f");
    }
}

