/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.CatalogTreeDto;
import com.rocoinfo.rocomall.dto.CategoryTreeDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/catalog"})
public class CatalogRestController
extends BaseController {
    @Autowired
    private ICatalogService catalogService;

    @RequestMapping(value={"/all"}, method={RequestMethod.GET})
    public Object all() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData((Object)this.catalogService.findAll());
        return result;
    }

    @RequestMapping(value={"/save"}, method={RequestMethod.POST})
    public Object create(@Valid Catalog catalog) {
        this.catalogService.insert((Object)catalog);
        StatusDto res = StatusDto.buildSuccessStatusDto();
        int level = new Long(0L).equals(catalog.getParentId()) ? 1 : 2;
        CategoryTreeDto dto = new CategoryTreeDto(catalog.getId(), catalog.getName(), level);
        res.setData((Object)dto);
        return res;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(@Valid Catalog catalog) {
        this.catalogService.update((Object)catalog);
        StatusDto res = StatusDto.buildSuccessStatusDto();
        int level = new Long(0L).equals(catalog.getParentId()) ? 1 : 2;
        CategoryTreeDto dto = new CategoryTreeDto(catalog.getId(), catalog.getName(), level);
        res.setData((Object)dto);
        return res;
    }

    @RequestMapping(value={"/{id}/get"})
    public Object get(@PathVariable Long id) {
        StatusDto res = StatusDto.buildSuccessStatusDto();
        res.setData(this.catalogService.getById(id));
        return res;
    }

    @RequestMapping(value={"/{catalogId}/getInfo"}, method={RequestMethod.GET})
    public Object getCatalog(@PathVariable Long catalogId) {
        Catalog catalog;
        StatusDto result = StatusDto.buildSuccessStatusDto();
        if (catalogId > 0L && (catalog = (Catalog)this.catalogService.getById(catalogId)) != null) {
            result.setData(ClassToMapUtil.dealSimple((Object)catalog, (String[])new String[]{"id", "name", "code", "status", "displayOrder", "parentId", "fullImgUrl"}));
        }
        return result;
    }

    @RequestMapping(value={"/{id}/delete"})
    public Object delete(@PathVariable Long id) {
        if (id != null) {
            this.catalogService.deleteById(id);
        }
        return StatusDto.buildSuccessStatusDto((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/tree"})
    public Object tree() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        CatalogTreeDto rootNode = new CatalogTreeDto();
        rootNode.setId(Long.valueOf(0L));
        CatalogTreeDto treeDto = CatalogTreeDto.constructTree((CatalogTreeDto)rootNode, (List)this.catalogService.findAll(), (int)1);
        result.setData((Object)treeDto.getChildren());
        return result;
    }
}

