/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdComment;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.IProdCommentService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prodcomment"})
public class ProdCommentRestControaller
extends BaseController {
    @Autowired
    private IProdCommentService prodCommentService;
    @Autowired
    private IOrderItemService orderItemService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="1") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keyword", keyword.trim());
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.prodCommentService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(@RequestParam(required=true) Long orderItemId, @RequestParam(required=true) String content, @RequestParam(required=false) String picturePath, @RequestParam(required=true) String level) {
        if (content.trim().equals("")) {
            return StatusDto.buildDataFailureStatusDto((String)"\u8bc4\u8bba\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OrderItem item = (OrderItem)this.orderItemService.getById(orderItemId);
        if (item == null) {
            return StatusDto.buildDataFailureStatusDto((String)"\u6ca1\u6709\u6b64\u8ba2\u5355\u4fe1\u606f\uff01");
        }
        Long userid = WebUtils.getLoggedUserId();
        if (!item.getUser().getId().equals(userid)) {
            return StatusDto.buildDataFailureStatusDto((String)"\u60a8\u6ca1\u6709\u8bc4\u8bba\u6b64\u8ba2\u5355\u5546\u54c1\u7684\u6743\u9650\uff01");
        }
        User user = new User();
        user.setId(userid);
        ProdComment com = new ProdComment();
        com.setContent(content);
        com.setCreateTime(new Date());
        com.setLevel(level);
        com.setOrderItem(item);
        com.setPicturePath(picturePath);
        com.setShow(ProdComment.Show.DISPLAY);
        com.setUser(user);
        try {
            this.prodCommentService.insert((Object)com);
            return StatusDto.buildSuccessStatusDto((String)"\u8bc4\u8bba\u6dfb\u52a0\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto((String)"\u8bc4\u8bba\u6dfb\u52a0\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(ProdComment prodComment) {
        try {
            this.prodCommentService.update((Object)prodComment);
            return StatusDto.buildSuccessStatusDto((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.logger.error("SupplierRestController create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)"\u4fee\u6539\u5931\u8d25\uff01");
        }
    }
}

