/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdStockApply;
import com.rocoinfo.rocomall.entity.StockApprove;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.cent.Apply;
import com.rocoinfo.rocomall.entity.cent.Approve;
import com.rocoinfo.rocomall.service.product.IProdStockApplyService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/prodstockapp"})
public class ProdStockAppRestController {
    @Autowired
    private IProdStockApplyService prodStockApplyService;

    @RequestMapping(method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String applyCode, @RequestParam(required=false) ProdStockApply.StockType type, @RequestParam(required=false) ProdStockApply.WareHouse warehouse, @RequestParam(required=false) Apply.State state, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="DESC") String orderSort, Model model) {
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)applyCode)) {
            params.put("applyCodes", StringUtils.split((String)applyCode, (String)" "));
        }
        if (type != null) {
            params.put("type", type);
        }
        if (warehouse != null) {
            params.put("warehouse", warehouse);
        }
        if (state != null) {
            params.put("state", state);
        }
        if (!SecurityUtils.getSubject().hasRole("admin")) {
            params.put("userId", WebUtils.getLoggedUserId());
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.prodStockApplyService.searchScrollPage((Map)params, (Pageable)pageRequest);
        List data = (List)ClassToMapUtil.dealSimple((Object)page.getContent(), (String[])new String[]{"id", "applyCode", "type", "warehouse", "applyer.name", "state", "applyDate"});
        return new PageTable(data, draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/{id}"})
    public Object get(@PathVariable Long id) {
        if (id == null) {
            return StatusDto.buildFailureStatusDto((String)"you has choose a wrong record!");
        }
        Optional optional = Optional.fromNullable((Object)this.prodStockApplyService.getById(id));
        if (!optional.isPresent()) {
            return StatusDto.buildFailureStatusDto((String)"can't find the record!");
        }
        StatusDto statusDto = StatusDto.buildDataSuccessStatusDto();
        statusDto.setData(optional.get());
        return statusDto;
    }

    @RequestMapping(value={"/create/{state}"}, method={RequestMethod.POST})
    public Object create(ProdStockApply prodStockApply, @PathVariable Apply.State state) {
        CollectionUtils.filter((Collection)prodStockApply.getProdStockApplyItems(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        boolean checkFlag = false;
        if (Apply.State.DRAFT.equals((Object)state)) {
            prodStockApply.setState(Apply.State.DRAFT);
        } else {
            if (ProdStockApply.StockType.OUT.equals((Object)prodStockApply.getType())) {
                checkFlag = true;
            }
            prodStockApply.setState(Apply.State.WAIT_AUDIT);
        }
        prodStockApply.setApplyCode(CodeGenerator.generateStockApplyCode((boolean)ProdStockApply.StockType.IN.equals((Object)prodStockApply.getType())));
        prodStockApply.setApplyer(new AdminUser(WebUtils.getLoggedUserId()));
        prodStockApply.setApplyDate(new Date());
        return this.prodStockApplyService.addOrUpdateStockApply(prodStockApply, checkFlag);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(ProdStockApply prodStockApply) {
        CollectionUtils.filter((Collection)prodStockApply.getProdStockApplyItems(), (Predicate)new /* Unavailable Anonymous Inner Class!! */);
        prodStockApply.setState(Apply.State.WAIT_AUDIT);
        prodStockApply.setApplyer(new AdminUser(WebUtils.getLoggedUserId()));
        boolean checkFlag = false;
        if (ProdStockApply.StockType.OUT.equals((Object)prodStockApply.getType())) {
            checkFlag = true;
        }
        return this.prodStockApplyService.addOrUpdateStockApply(prodStockApply, checkFlag);
    }

    @RequestMapping(value={"/approve/{id}/{result}"}, method={RequestMethod.GET})
    public Object approve(@PathVariable Long id, @PathVariable Approve.ApproveResult result) {
        ProdStockApply prodStockApply = (ProdStockApply)this.prodStockApplyService.getById(id);
        StockApprove approve = new StockApprove();
        approve.setApply((Apply)prodStockApply);
        approve.setApprover(new AdminUser(WebUtils.getLoggedUserId()));
        approve.setAuditDate(new Date());
        approve.setResult(result);
        return this.prodStockApplyService.auditStockAppoly(approve, result);
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }
}

