/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdTemp;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.account.AdminLog;
import com.rocoinfo.rocomall.service.impl.AdminLogService;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.IPriceHistoryService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/product"})
public class ProductRestController
extends BaseController {
    @Autowired
    private IProductService productService;
    @Autowired
    private ICatalogService catalogService;
    @Autowired
    private AdminLogService adminLogService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IInstoreOrderService instoreService;
    @Autowired
    private IOrderOutStoreService outstoreService;

    @RequestMapping(value={"{id}/detail"}, method={RequestMethod.GET})
    public Object getJson(@PathVariable long id) {
        Product product = (Product)this.productService.getById(Long.valueOf(id));
        this.productService.buildDetail(product);
        StatusDto statusDto = StatusDto.buildDataSuccessStatusDto();
        statusDto.setData((Object)product);
        return statusDto;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public Object create(String productJson) {
        Product product = this.convertJsonToObject(productJson);
        if (product == null) {
            return StatusDto.buildDataFailureStatusDto((String)"\u8bf7\u68c0\u67e5json\u683c\u5f0f\u662f\u5426\u6b63\u786e!");
        }
        product.setStatus(Product.Status.DRAFT);
        this.productService.create(product, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"create/temp"}, method={RequestMethod.POST})
    public Object createTemp(String productJson) {
        if (StringUtils.isBlank((CharSequence)productJson)) {
            return StatusDto.buildDataFailureStatusDto((String)"json\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        productJson = this.replaceUnnecessary(productJson);
        StatusDto dto = StatusDto.buildDataSuccessStatusDto();
        Long id = this.productService.createTemp(productJson, WebUtils.getLoggedUserId());
        dto.setData((Object)id);
        return dto;
    }

    @RequestMapping(value={"get/temp"}, method={RequestMethod.GET})
    public Object getTempProd(Product product) {
        StatusDto dto = StatusDto.buildDataSuccessStatusDto();
        product.setStatus(Product.Status.DRAFT);
        ProdTemp temp = this.productService.getLastProdTempByUserId(WebUtils.getLoggedUserId());
        if (temp != null) {
            dto.setData((Object)temp.getJsonString());
        }
        return dto;
    }

    @RequestMapping(value={"{id}/update"}, method={RequestMethod.POST})
    public Object update(@PathVariable long id, String productJson) {
        Product product = this.convertJsonToObject(productJson);
        if (product == null) {
            return StatusDto.buildDataFailureStatusDto((String)"\u8bf7\u68c0\u67e5json\u683c\u5f0f\u662f\u5426\u6b63\u786e!");
        }
        product.setId(Long.valueOf(id));
        this.productService.update(product, WebUtils.getLoggedUserId());
        return StatusDto.buildSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/update/temp"}, method={RequestMethod.POST})
    public Object updateTemp(@PathVariable long id, String productJson) {
        if (StringUtils.isBlank((CharSequence)productJson)) {
            return StatusDto.buildDataFailureStatusDto((String)"json\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        productJson = this.replaceUnnecessary(productJson);
        this.productService.updateTemp(productJson, Long.valueOf(id));
        return StatusDto.buildSuccessStatusDto();
    }

    private Product convertJsonToObject(String jsonStr) {
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return null;
            }
            jsonStr = this.replaceUnnecessary(jsonStr);
            this.logger.info(jsonStr);
            return (Product)JsonUtils.fromJson((String)jsonStr, Product.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String replaceUnnecessary(String jsonStr) {
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return null;
        }
        return jsonStr.replaceAll("&quot;", "\"");
    }

    @RequestMapping(value={"{id}/discard"}, method={RequestMethod.POST})
    public Object discard(@PathVariable long id) {
        this.productService.discard(id, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/submit-audit"}, method={RequestMethod.POST})
    public Object submitAudit(@PathVariable Long id) {
        this.productService.submitAudit(id, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/audit-refuse"}, method={RequestMethod.POST})
    public Object auditRefuse(@PathVariable Long id) {
        this.productService.auditRefuse(id, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/audit-ok"}, method={RequestMethod.POST})
    public Object auditOk(@PathVariable Long id) {
        this.productService.auditOk(id, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/de-list"}, method={RequestMethod.POST})
    public Object deList(@PathVariable Long id) {
        this.productService.delist(id, WebUtils.getLoggedUserId());
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{id}/list"}, method={RequestMethod.POST})
    public Object list(@PathVariable Long id) {
        try {
            this.productService.list(id, WebUtils.getLoggedUserId());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
        return StatusDto.buildDataSuccessStatusDto();
    }

    @RequestMapping(value={"{skuId}/price-history"}, method={RequestMethod.GET})
    public Object priceHistory(@PathVariable long skuId, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="time") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("skuId", skuId);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.priceHistoryService.searchScrollPage(params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"{productId}/admin-log"}, method={RequestMethod.GET})
    public Object adminLog(@PathVariable long productId, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="action_time") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("objectType", AdminLog.ObjectType.PRODUCT);
        params.put("objectId", productId);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.adminLogService.search(params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"{productId}/instoreRecord"})
    public Object instoreRecords(@PathVariable Long productId, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length) {
        PageRequest pageable = new PageRequest(start, length);
        Page page = this.instoreService.searchInstoreRecordsByProdId(productId, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"{productId}/outstoreRecord"})
    public Object outstoreRecords(@PathVariable Long productId, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length) {
        PageRequest pageable = new PageRequest(start, length);
        Page page = this.outstoreService.searchOutstoreRecordsByProdId(productId, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }
}

