/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import com.rocoinfo.rocomall.utils.CustomFunctions;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sku"})
public class SkuRestController
extends BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ICatalogService catalogService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IInstoreOrderService instoreOrderService;
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private IDictWarehouseService dictWarehouseService;
    @Autowired
    private IOrderItemService orderItemService;

    @RequestMapping
    public Object managerSku(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) String source, @RequestParam(required=false) Product.Status status, @RequestParam(required=false) Sku.StockStatus stockStatus, @RequestParam(required=false) Boolean isOnSale, @RequestParam(required=false) Long catalogId, @RequestParam(required=false) Long supplierId, @RequestParam(required=false) Long brandId, @RequestParam(required=false) Boolean isVisual, @RequestParam(required=false) Boolean supportDiscount, @RequestParam(required=false) List<Long> excludeSkuIds) {
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keywords", StringUtils.split((String)keyword, (String)" "));
        }
        if (catalogId != null) {
            params.put("catalogIds", this.catalogService.findSubTreeIds(catalogId));
        }
        if (StringUtils.isNotBlank((CharSequence)source) && source.equals("skuStore") && StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("sourceCatalogIds", this.catalogService.findCatalogIdsbyName(keyword));
        }
        if (!CollectionUtils.isEmpty(excludeSkuIds)) {
            params.put("excludeSkuIds", excludeSkuIds);
        }
        params.put("status", status);
        params.put("stockStatus", stockStatus);
        params.put("isVisual", isVisual);
        params.put("brandId", brandId);
        Page page = this.skuService.searchScrollPage(params, (Pageable)pageable);
        List skuList = page.getContent();
        for (Sku sku : skuList) {
            if (sku.getProduct().getStatus() == null) continue;
            sku.setCanDos((List)CustomFunctions.canDoMap.get(sku.getProduct().getStatus().name()));
        }
        return new PageTable(skuList, draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/{sukId}"}, method={RequestMethod.GET})
    public Object getSuk(@PathVariable Long sukId) {
        if (sukId == null) {
            return StatusDto.buildFailureStatusDto();
        }
        StatusDto sd = StatusDto.buildSuccessStatusDto();
        Sku sku = (Sku)this.skuService.getById(sukId);
        this.skuService.buildDetail(sku);
        sd.setData((Object)sku);
        return sd;
    }

    @RequestMapping(value={"/code/{code}"}, method={RequestMethod.GET})
    public Object getSkuByCode(@PathVariable String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return StatusDto.buildFailureStatusDto();
        }
        StatusDto sd = StatusDto.buildSuccessStatusDto();
        Sku sku = this.skuService.getByCode(code);
        this.skuService.buildDetail(sku);
        sd.setData((Object)sku);
        return sd;
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(Sku sku) {
        try {
            this.skuService.update((Object)sku);
            return StatusDto.buildSuccessStatusDto((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("SupplierRestController create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }
}

