/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/supplier"})
public class SupplierRestController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);
    @Autowired
    private ISupplierService supplierService;

    @RequestMapping(method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String keyword, @RequestParam(required=false) String draw, @RequestParam(required=false) Boolean useable, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keyword", StringUtils.splitByWholeSeparator((String)keyword.trim(), (String)" "));
        }
        WebUtils.setObjectValue(params, (String)"useable", (Object)useable);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.supplierService.searchScrollPage(params, (Pageable)pageable);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}/getInfo"})
    public Object get(@PathVariable Long id) {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(this.supplierService.getById(id));
        return result;
    }

    @RequestMapping(value={"/create"})
    public Object create(Supplier supplier) {
        try {
            this.supplierService.insert((Object)supplier);
            return StatusDto.buildSuccessStatusDto((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("SupplierRestController create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    public Object update(Supplier supplier) {
        try {
            this.supplierService.update((Object)supplier);
            return StatusDto.buildSuccessStatusDto((String)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("SupplierRestController update error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/loginedSuppliers"})
    public Object getLoginedSuppliers() {
        try {
            StatusDto result = StatusDto.buildSuccessStatusDto();
            result.setData((Object)this.supplierService.findUseableSupplysByAdminId(WebUtils.getLoggedUserId()));
            return result;
        }
        catch (Exception e) {
            this.logger.error("SupplierRestController update error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }
}

