/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.admin.product;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.VirtualProductExcelDto;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.VirtualProduct;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.IVirtualProductService;
import com.rocoinfo.rocomall.utils.ExcelMergeRegion;
import com.rocoinfo.rocomall.utils.ExcelUtil;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springside.modules.utils.Collections3;

@RestController
@RequestMapping(value={"/api/virtualprod"})
public class VirtualProductRestController {
    @Autowired
    private IVirtualProductService virtualProductService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IProductService productService;
    @Autowired
    private IUploadService uploadService;

    @RequestMapping(method={RequestMethod.GET})
    public Object list(@RequestParam(required=false) String keyword, @RequestParam(required=false) VirtualProduct.Status status, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="DESC") String orderSort) {
        HashMap params = Maps.newHashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keywords", StringUtils.split((String)keyword, (String)" "));
        }
        if (status != null) {
            params.put("status", status);
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.virtualProductService.searchScrollPage((Map)params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, (int)page.getTotalElements());
    }

    @RequestMapping(value={"/{id}"})
    public Object get(@PathVariable Long id) {
        if (id == null || id < 1L) {
            return StatusDto.buildFailureStatusDto((String)"\u53c2\u6570Id\u4e0d\u5408\u6cd5");
        }
        Optional optional = Optional.fromNullable((Object)this.virtualProductService.getById(id));
        if (!optional.isPresent()) {
            return StatusDto.buildFailureStatusDto((String)("can't find the VirtualProduct by id:" + id));
        }
        StatusDto statusDto = StatusDto.buildDataSuccessStatusDto();
        statusDto.setData(optional.get());
        return statusDto;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(VirtualProduct virtualProduct) {
        String skuCode = virtualProduct.getSkuCode();
        Sku sku = this.skuService.getByCode(skuCode);
        if (sku == null || !((Product)this.productService.getById(sku.getProduct().getId())).getVisual().booleanValue()) {
            return StatusDto.buildFailureStatusDto((String)String.format("code\u4e3a%s\u7684\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u865a\u62df\u5546\u54c1", skuCode));
        }
        if (VirtualProduct.Type.EXCHANGE_CODE.equals((Object)virtualProduct.getType())) {
            virtualProduct.setCardno("");
            virtualProduct.setSerialNo("");
        }
        if (this.isDuplicate(virtualProduct)) {
            return StatusDto.buildFailureStatusDto((String)String.format("code\u4e3a%s\u7684\u5546\u54c1\u5e8f\u5217\u53f7\u3001\u5361\u53f7\u3001\u5bc6\u7801\u4e0d\u80fd\u540c\u65f6\u91cd\u590d", skuCode));
        }
        virtualProduct.setStatus(VirtualProduct.Status.UNUSED);
        this.virtualProductService.insert((Object)virtualProduct);
        this.skuService.increaseStockOnRefundIfCanUse(sku.getId().longValue(), 1);
        return StatusDto.buildSuccessStatusDto((String)"\u865a\u62df\u5546\u54c1\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(VirtualProduct virtualProduct) {
        String skuCode = virtualProduct.getSkuCode();
        Sku sku = this.skuService.getByCode(skuCode);
        if (sku == null || !((Product)this.productService.getById(sku.getProduct().getId())).getVisual().booleanValue()) {
            return StatusDto.buildFailureStatusDto((String)String.format("code\u4e3a%s\u7684\u5546\u54c1\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u865a\u62df\u5546\u54c1", skuCode));
        }
        VirtualProduct tempVirProd = (VirtualProduct)this.virtualProductService.getById(virtualProduct.getId());
        virtualProduct.setType(tempVirProd.getType());
        if (this.isDuplicate(virtualProduct)) {
            return StatusDto.buildFailureStatusDto((String)String.format("code\u4e3a%s\u7684\u5546\u54c1\u5e8f\u5217\u53f7\u3001\u5361\u53f7\u3001\u5bc6\u7801\u4e0d\u80fd\u540c\u65f6\u91cd\u590d", skuCode));
        }
        if (VirtualProduct.Type.EXCHANGE_CODE.equals((Object)virtualProduct.getType())) {
            virtualProduct.setCardno(null);
            virtualProduct.setSerialNo(null);
        }
        this.virtualProductService.update((Object)virtualProduct);
        return StatusDto.buildSuccessStatusDto((String)"\u66f4\u65b0\u6210\u529f!");
    }

    @RequestMapping(value={"destroy/{id}"}, method={RequestMethod.GET})
    public Object abolish(@PathVariable Long id) {
        VirtualProduct virProduct = (VirtualProduct)this.virtualProductService.getById(id);
        if (virProduct == null) {
            return StatusDto.buildFailureStatusDto((String)("\u865a\u62df\u5546\u54c1[" + id + "]\u4e0d\u5b58\u5728!"));
        }
        if (!VirtualProduct.Status.UNUSED.equals((Object)virProduct.getStatus())) {
            return StatusDto.buildFailureStatusDto((String)"\u53ea\u6709\u5c1a\u672a\u4f7f\u7528\u7684\u865a\u62df\u5361\u624d\u53ef\u4ee5\u4f5c\u5e9f!");
        }
        VirtualProduct update = new VirtualProduct();
        update.setId(id);
        update.setStatus(VirtualProduct.Status.CANCEL);
        this.virtualProductService.update((Object)update);
        return StatusDto.buildSuccessStatusDto((String)"\u4f5c\u5e9f\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/import"})
    public Object batchImp(@RequestParam(required=true) String filePath) {
        File file = this.uploadService.submitPathAndGetfile(filePath);
        List cardList = ExcelUtil.getInstance().readExcel2ObjsByFile(file, VirtualProductExcelDto.class);
        return this.importData(cardList);
    }

    private StatusDto<String> importData(List<VirtualProductExcelDto> cardList) {
        if (CollectionUtils.isEmpty(cardList)) {
            return StatusDto.buildSuccessStatusDto((String)"excel\u4e2d\u6ca1\u6709\u865a\u62df\u5546\u54c1,\u65e0\u9700\u5bfc\u5165");
        }
        ArrayList canUpdateDtos = Lists.newArrayList();
        ArrayList canNotUpdateDtos = Lists.newArrayList();
        int lineNumber = 1;
        LinkedHashMap errorMsg = Maps.newLinkedHashMap();
        String lineTemp = "\u7b2c%s\u884c";
        for (VirtualProductExcelDto dto : cardList) {
            ++lineNumber;
            String skuCode = dto.getSkuCode();
            Sku sku = this.skuService.getByCode(skuCode);
            if (sku == null || !((Product)this.productService.getById(sku.getProduct().getId())).getVisual().booleanValue()) {
                canNotUpdateDtos.add(dto);
                errorMsg.put(String.format(lineTemp, lineNumber), "\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u865a\u62df\u5546\u54c1");
                continue;
            }
            try {
                VirtualProduct virtualProduct = new VirtualProduct();
                virtualProduct.setSkuCode(skuCode);
                virtualProduct.setPasswd(dto.getPasswd());
                virtualProduct.setType(VirtualProduct.Type.valueOfName((String)dto.getType()));
                if (VirtualProduct.Type.CARD_PWD.equals((Object)virtualProduct.getType())) {
                    virtualProduct.setCardno(dto.getCardno());
                    virtualProduct.setSerialNo(dto.getSerialNo());
                } else {
                    virtualProduct.setCardno("");
                    virtualProduct.setSerialNo("");
                }
                virtualProduct.setExpired((java.util.Date)Date.valueOf(dto.getExpired()));
                virtualProduct.setStatus(VirtualProduct.Status.UNUSED);
                if (null == virtualProduct.getType()) {
                    canNotUpdateDtos.add(dto);
                    errorMsg.put(String.format(lineTemp, lineNumber), "\u7c7b\u578b\u7801\u4e0d\u5bf9");
                    continue;
                }
                if (this.isDuplicate(virtualProduct)) {
                    canNotUpdateDtos.add(dto);
                    errorMsg.put(String.format(lineTemp, lineNumber), "\u5e8f\u5217\u53f7\u3001\u5361\u53f7\u3001\u5bc6\u7801\u4e0d\u80fd\u540c\u65f6\u91cd\u590d");
                    continue;
                }
                if (VirtualProduct.Type.CARD_PWD.equals((Object)virtualProduct.getType())) {
                    if (StringUtils.isBlank((CharSequence)dto.getCardno()) || StringUtils.isBlank((CharSequence)dto.getPasswd())) {
                        canNotUpdateDtos.add(dto);
                        errorMsg.put(String.format(lineTemp, lineNumber), "\u5361\u5bc6\u7c7b\u578b,\u5361\u53f7\u548c\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        continue;
                    }
                } else if (VirtualProduct.Type.EXCHANGE_CODE.equals((Object)virtualProduct.getType()) && StringUtils.isBlank((CharSequence)dto.getPasswd())) {
                    canNotUpdateDtos.add(dto);
                    errorMsg.put(String.format(lineTemp, lineNumber), "\u5151\u6362\u7801\u7c7b\u578b,\u5151\u6362\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    continue;
                }
                this.virtualProductService.insert((Object)virtualProduct);
                this.skuService.increaseStockOnRefundIfCanUse(sku.getId().longValue(), 1);
                canUpdateDtos.add(dto);
            }
            catch (Exception e) {
                canNotUpdateDtos.add(dto);
                errorMsg.put(String.format(lineTemp, lineNumber), e.getMessage());
            }
        }
        if (Collections3.isNotEmpty((Collection)canNotUpdateDtos)) {
            StringBuffer error = new StringBuffer(100);
            for (String k : errorMsg.keySet()) {
                error.append(k).append(":").append((String)errorMsg.get(k)).append(";");
            }
            return StatusDto.buildFailureStatusDto((String)error.toString());
        }
        return StatusDto.buildSuccessStatusDto((String)"\u5bfc\u5165\u6210\u529f");
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public Object batchExport(@RequestParam(required=false) String keyword, @RequestParam(required=false) VirtualProduct.Status status, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, HttpServletResponse response) {
        String vpTemplate = "template/virtualproduct_template.xls";
        try {
            String excelFileName = URLEncoder.encode("virtualproduct", "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("content-disposition", "attachment;filename=" + excelFileName + ".xls");
            PageRequest pageRequest = new PageRequest(0, 30000, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
            HashMap params = Maps.newHashMap();
            if (StringUtils.isNotBlank((CharSequence)keyword)) {
                params.put("keywords", StringUtils.split((String)keyword, (String)" "));
            }
            if (status != null) {
                params.put("status", status);
            }
            Page page = this.virtualProductService.searchScrollPage((Map)params, (Pageable)pageRequest);
            ArrayList exportDataList = Lists.newArrayList();
            for (VirtualProduct vp : page.getContent()) {
                VirtualProductExcelDto dto = new VirtualProductExcelDto();
                dto.setCardno(vp.getCardno());
                dto.setExpired(vp.getExpired().toString());
                dto.setPasswd(vp.getPasswd());
                dto.setSerialNo(vp.getSerialNo());
                dto.setSkuCode(vp.getSkuCode());
                dto.setStatus(vp.getStatus().getLabel());
                dto.setType(vp.getType().getLabel());
                exportDataList.add(dto);
            }
            ExcelUtil.getInstance().exportObj2ExcelByTemplate((Map)null, "template/virtualproduct_template.xls", (OutputStream)response.getOutputStream(), (List)exportDataList, VirtualProductExcelDto.class, Boolean.TRUE.booleanValue());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return StatusDto.buildSuccessStatusDto((String)"\u5bfc\u51fa\u6210\u529f");
    }

    @RequestMapping(value={"/download"})
    public Object downloadTemplate(HttpServletResponse response) {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment; filename=cardtemplate.xls");
        try {
            List emptyList = Collections.emptyList();
            ExcelUtil.getInstance().exportObj2Excel((OutputStream)response.getOutputStream(), emptyList, VirtualProductExcelDto.class, false, new ExcelMergeRegion[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return StatusDto.buildSuccessStatusDto();
    }

    @InitBinder
    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(java.util.Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"), true));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringEscapeEditor());
    }

    private boolean isDuplicate(VirtualProduct virProduct) {
        long count = 0L;
        count = VirtualProduct.Type.CARD_PWD.equals((Object)virProduct.getType()) ? this.virtualProductService.countCardPwd(virProduct) : this.virtualProductService.countExchangeCode(virProduct);
        return count > 0L;
    }
}

