/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictCentAttribution;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.dict.IDictCentAttributionService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/centconsume/owner"})
public class DictCentAttributionRestController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(DictCentAttributionRestController.class);
    @Autowired
    private IDictCentAttributionService dictAttributionService;

    @RequestMapping
    public Object list(@RequestParam(required=false) Status status, @RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap params = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            WebUtils.setObjectValue(params, (String)"keywords", (Object)StringUtils.split((String)keyword, (String)" "));
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.dictAttributionService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}/getInfo"})
    public Object get(@PathVariable Long id) {
        DictCentAttribution dictCentConsumeOwner = (DictCentAttribution)this.dictAttributionService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)dictCentConsumeOwner);
        return result;
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(DictCentAttribution centConsumeOwner) {
        try {
            this.dictAttributionService.insert((Object)centConsumeOwner);
            return StatusDto.buildSuccessStatusDto((String)"\u7c7b\u578b\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("DictCentConsumeTypeRestController create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(DictCentAttribution centConsumeOwner) {
        try {
            this.dictAttributionService.update((Object)centConsumeOwner);
            return StatusDto.buildSuccessStatusDto((String)"\u7c7b\u578b\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("DictCentConsumeTypeRestController update error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/getAll"})
    public Object getAll() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData((Object)this.dictAttributionService.findAll());
        return result;
    }
}

