/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictRankType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.dict.IDictRankTypeService;
import com.rocoinfo.rocomall.utils.WebUtils;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rankType"})
public class DictRankTypeRestController
extends BaseController {
    @Autowired
    private IDictRankTypeService dictRankTypeService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword, @RequestParam(required=false) Status status) {
        HashMap params = new HashMap();
        WebUtils.setStringValue(params, (String)"keyword", (String)keyword);
        WebUtils.setObjectValue(params, (String)"status", (Object)status);
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.dictRankTypeService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + "").intValue());
    }

    @RequestMapping(value={"/{id}"})
    public Object get(@PathVariable Long id) {
        DictRankType rankType = (DictRankType)this.dictRankTypeService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)rankType);
        return result;
    }

    @RequestMapping(value={"/create"})
    public Object create(DictRankType rankType) {
        if (this.dictRankTypeService.isExistName(rankType.getName())) {
            return StatusDto.buildFailureStatusDto((String)"\u6392\u884c\u699c\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        rankType.setStatus(Status.OPEN);
        this.dictRankTypeService.insert((Object)rankType);
        return StatusDto.buildSuccessStatusDto((String)"\u6392\u884c\u699c\u7c7b\u578b\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"/getAll"})
    public Object getAll(@RequestParam(required=false) Status status) {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData((Object)this.dictRankTypeService.findAllWithStatus(status));
        return result;
    }

    @RequestMapping(value={"/update"})
    public Object save(DictRankType rankType) {
        DictRankType oldRankType = (DictRankType)this.dictRankTypeService.getById(rankType.getId());
        if (!oldRankType.getName().equalsIgnoreCase(rankType.getName()) && this.dictRankTypeService.isExistName(rankType.getName())) {
            return StatusDto.buildFailureStatusDto((String)"\u6392\u884c\u699c\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u6362\u4e2a\u540d\u79f0");
        }
        this.dictRankTypeService.update((Object)rankType);
        return StatusDto.buildSuccessStatusDto((String)"\u6392\u884c\u699c\u7c7b\u578b\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/{id}/switch"}, method={RequestMethod.GET})
    public Object switchStatus(@PathVariable Long id, @RequestParam Status status) {
        this.dictRankTypeService.switchStatus(id, status);
        return StatusDto.buildDataSuccessStatusDto();
    }
}

