/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictSkuMeta;
import com.rocoinfo.rocomall.rest.admin.product.SupplierRestController;
import com.rocoinfo.rocomall.service.dict.IDictSkuMetaService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/dictskumeta"})
public class DictSkuMetaRestController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);
    @Autowired
    private IDictSkuMetaService dictSkuMetaService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="1") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap params = new HashMap();
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.dictSkuMetaService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}/getInfo"})
    public Object get(@PathVariable Long id) {
        DictSkuMeta dictSkuMeta = (DictSkuMeta)this.dictSkuMetaService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)dictSkuMeta);
        return result;
    }

    @RequestMapping(value={"/create"})
    public Object create(DictSkuMeta dictSkuMeta) {
        this.dictSkuMetaService.insert((Object)dictSkuMeta);
        return StatusDto.buildSuccessStatusDto((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @RequestMapping(value={"/update"})
    public Object update(DictSkuMeta dictSkuMeta) {
        this.dictSkuMetaService.update((Object)dictSkuMeta);
        return StatusDto.buildSuccessStatusDto((String)"\u4fee\u6539\u6210\u529f");
    }

    @RequestMapping(value={"/delete/{id}"})
    public Object delete(@PathVariable Long id) {
        this.dictSkuMetaService.deleteById(id);
        return StatusDto.buildSuccessStatusDto((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/getAll"})
    public Object getAll() {
        StatusDto dto = StatusDto.buildSuccessStatusDto();
        dto.setData((Object)this.dictSkuMetaService.findAll());
        return dto;
    }
}

