/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.rest.admin.product.SupplierRestController;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/warehouse"})
public class DictWarehouseRestController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);
    @Autowired
    private IDictWarehouseService dictWarehouseService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="1") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator((String)keyword.trim(), (String)" ")));
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.dictWarehouseService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}/getInfo"})
    public Object get(@PathVariable Long id) {
        DictWarehouse dictWarehouse = (DictWarehouse)this.dictWarehouseService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)dictWarehouse);
        return result;
    }

    @RequestMapping(value={"/create"})
    public Object create(DictWarehouse dictWarehouse) {
        try {
            this.dictWarehouseService.insert((Object)dictWarehouse);
            return StatusDto.buildSuccessStatusDto((String)"\u4ed3\u5e93\u5b57\u5178\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(" create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    public Object update(DictWarehouse dictWarehouse) {
        try {
            this.dictWarehouseService.update((Object)dictWarehouse);
            return StatusDto.buildSuccessStatusDto((String)"\u4ed3\u5e93\u5b57\u5178\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(" create update.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/all"})
    public Object findAllDictWarehouse() {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)this.dictWarehouseService.findAll());
        return result;
    }
}

