/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict.express;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/express"})
public class DictExpressRestController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(DictExpressRestController.class);
    @Autowired
    private IDictExpressService dictExpService;
    @Autowired
    protected IDictProviceCityService provCityService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="1") int start, @RequestParam(defaultValue="20") int length, @RequestParam(defaultValue="id") String orderColumn, @RequestParam(defaultValue="DESC") String orderSort, @RequestParam(required=false) String keyword) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator((String)keyword.trim(), (String)" ")));
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf((String)orderSort.toUpperCase()), new String[]{orderColumn}));
        Page page = this.dictExpService.searchScrollPage(params, (Pageable)pageRequest);
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/{id}/getInfo"})
    public Object get(@PathVariable Long id) {
        DictExpress dictExpress = (DictExpress)this.dictExpService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)dictExpress);
        return result;
    }

    @RequestMapping(value={"/create"})
    public Object create(DictExpress express) {
        try {
            this.dictExpService.insert((Object)express);
            return StatusDto.buildSuccessStatusDto((String)"\u5feb\u9012\u516c\u53f8\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(" create error.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"})
    public Object update(DictExpress express) {
        try {
            this.dictExpService.update((Object)express);
            return StatusDto.buildSuccessStatusDto((String)"\u5feb\u9012\u516c\u53f8\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error(" create update.{}", (Throwable)e);
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/findcitys/{id}"})
    public Object findCitys(@PathVariable Long id) {
        try {
            List citys = this.dictExpService.findAllCityById(id);
            StatusDto result = StatusDto.buildDataSuccessStatusDto();
            result.setData((Object)citys);
            return result;
        }
        catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/updatecitys"})
    public Object findCitys(@RequestParam Long id, @RequestParam(required=false) List<Long> citys) {
        List expCityList;
        if (id == null) {
            return StatusDto.buildDataFailureStatusDto((String)"\u5feb\u9012\u516c\u53f8id\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isNotEmpty(citys) && CollectionUtils.isNotEmpty((Collection)(expCityList = this.dictExpService.findCityExpressByBoundedCityIds(citys)))) {
            StringBuilder errorBuf = new StringBuilder();
            for (DictProviceCity city : expCityList) {
                if (city.getExpress().getId().equals(id)) continue;
                errorBuf.append("[" + city.getName() + " \u5df2\u7ed1\u5b9a  " + city.getExpress().getName() + "]").append(",");
            }
            if (errorBuf.length() > 0) {
                return StatusDto.buildDataFailureStatusDto((String)errorBuf.toString());
            }
        }
        try {
            DictExpress express = new DictExpress();
            ArrayList<DictProviceCity> cityList = new ArrayList<DictProviceCity>();
            if (citys != null) {
                for (Long ids : citys) {
                    DictProviceCity dictProviceCity = new DictProviceCity();
                    dictProviceCity.setId(ids);
                    cityList.add(dictProviceCity);
                }
            }
            express.setId(id);
            express.setCitys(cityList);
            this.dictExpService.updateCitys(express);
            return StatusDto.buildDataSuccessStatusDto();
        }
        catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/gotocitys"})
    public Object buildProvCity(@RequestParam Long id) {
        List boundCityIds = this.dictExpService.findBoundedCityIdsById(id);
        return this.provCityService.buildProvCityNodes(boundCityIds);
    }

    @RequestMapping(value={"/all"})
    public Object findAllExpress() {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData((Object)this.dictExpService.findAll());
        return result;
    }
}

