/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.rest.dict.express;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeTemplateService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/expressTemplate"})
public class ExpressTemplateRestController
extends BaseController {
    @Autowired
    private IDictExpressService dictExpService;
    @Autowired
    private IExpressFeeTemplateService expressTemplateService;

    @RequestMapping
    public Object list(@RequestParam(required=false) String draw, @RequestParam(defaultValue="0") int start, @RequestParam(defaultValue="20") int length) {
        PageRequest pageRequest = new PageRequest(start, length);
        HashMap params = Maps.newHashMap();
        Page page = this.expressTemplateService.searchScrollPage((Map)params, (Pageable)pageRequest);
        this.buildDictExpress(page.getContent());
        return new PageTable(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public Object create(ExpressFeeTemplate feeTemplate) {
        try {
            if (this.expressTemplateService.countTemplateByExpress(feeTemplate) > 0L) {
                return StatusDto.buildFailureStatusDto((String)"\u8be5\u5feb\u9012\u516c\u53f8\u5df2\u521b\u5efa\u6a21\u677f,\u8bf7\u6362\u4e2a\u5feb\u9012\u516c\u53f8");
            }
            this.pretreatTemplate(feeTemplate);
            this.expressTemplateService.insert((Object)feeTemplate);
            return StatusDto.buildSuccessStatusDto((String)"\u6a21\u677f\u521b\u5efa\u6210\u529f");
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public Object update(ExpressFeeTemplate feeTemplate) {
        try {
            if (this.expressTemplateService.countTemplateByExpress(feeTemplate) > 0L) {
                return StatusDto.buildFailureStatusDto((String)"\u8be5\u5feb\u9012\u516c\u53f8\u5df2\u521b\u5efa\u6a21\u677f,\u8bf7\u6362\u4e2a\u5feb\u9012\u516c\u53f8");
            }
            this.pretreatTemplate(feeTemplate);
            this.expressTemplateService.update((Object)feeTemplate);
            return StatusDto.buildSuccessStatusDto((String)"\u5feb\u9012\u6a21\u677f\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            return StatusDto.buildFailureStatusDto((String)e.getMessage());
        }
    }

    @RequestMapping(value={"/{id}/clone"})
    public Object cloneTemplate(@PathVariable Long id) {
        try {
            this.expressTemplateService.cloneTemplate(id);
            return StatusDto.buildSuccessStatusDto((String)"\u6a21\u677f\u590d\u5236\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto((String)e.getMessage());
        }
    }

    private void buildDictExpress(List<ExpressFeeTemplate> feeTemplateList) {
        if (CollectionUtils.isNotEmpty(feeTemplateList)) {
            Map expressMap = this.dictExpService.findAllExpressMap();
            for (ExpressFeeTemplate feeTemplate : feeTemplateList) {
                try {
                    feeTemplate.setExpress((DictExpress)expressMap.get(feeTemplate.getExpress().getId()));
                }
                catch (Exception e) {
                    DictExpress exp = new DictExpress();
                    exp.setName("");
                    feeTemplate.setExpress(exp);
                }
            }
        }
    }

    private void pretreatTemplate(ExpressFeeTemplate feeTemplate) {
        if (CollectionUtils.isNotEmpty((Collection)feeTemplate.getItems())) {
            Iterator itemIter = feeTemplate.getItems().iterator();
            while (itemIter.hasNext()) {
                ExpressFeeItem item = (ExpressFeeItem)itemIter.next();
                if (item.getQamt() == null) {
                    itemIter.remove();
                    continue;
                }
                item.setItemCitys(this.convertToCityItemList(item.getCityIds()));
            }
        }
    }

    private List<FeeItemCity> convertToCityItemList(String cityIds) {
        ArrayList cityList = null;
        if (StringUtils.isNotBlank((CharSequence)cityIds)) {
            String[] cityIdArray;
            cityList = Lists.newArrayList();
            for (String cityId : cityIdArray = StringUtils.split((String)cityIds, (String)",")) {
                FeeItemCity item = new FeeItemCity();
                item.setCityId(Long.valueOf(NumberUtils.toLong((String)cityId)));
                cityList.add(item);
            }
        }
        return cityList;
    }
}

