/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.account.AdminUserDao;
import com.rocoinfo.rocomall.repository.account.RoleDao;
import com.rocoinfo.rocomall.service.LogoutService;
import com.rocoinfo.rocomall.service.impl.LoginLogService;
import com.rocoinfo.rocomall.shiro.token.MyUsernamePasswordToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.ExpiredCredentialsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Autowired
    private LogoutService logoutService;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private AdminUserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private LoginLogService loginLogService;
    private final Logger logger = LoggerFactory.getLogger(LoginService.class);

    public Object login(String loginName, String password, boolean rememberMe, UserType userType) {
        try {
            this.login((AuthenticationToken)new MyUsernamePasswordToken(loginName, password, rememberMe, userType));
            return StatusDto.buildSuccessStatusDto();
        }
        catch (AuthenticationException e) {
            return StatusDto.buildDataFailureStatusDto((String)this.getErrorResponseEntity(e));
        }
    }

    public void login(AuthenticationToken token) throws AuthenticationException {
        Subject subject = SecurityUtils.getSubject();
        if (subject.getPrincipal() != null) {
            this.logoutService.logout();
        }
        subject.login(token);
    }

    private String getErrorResponseEntity(AuthenticationException e) {
        String loginFail = "\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e";
        if (e instanceof IncorrectCredentialsException) {
            return "\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e";
        }
        if (e instanceof ExpiredCredentialsException) {
            return "\u5bc6\u7801\u5df2\u8fc7\u671f";
        }
        if (e instanceof CredentialsException) {
            return "\u5bc6\u7801\u9a8c\u8bc1\u5931\u8d25";
        }
        if (e instanceof UnknownAccountException) {
            return "\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e";
        }
        if (e instanceof LockedAccountException) {
            return "\u7528\u6237\u5df2\u88ab\u9501\u5b9a";
        }
        if (e instanceof DisabledAccountException) {
            return "\u7528\u6237\u5df2\u88ab\u7981\u7528";
        }
        if (e instanceof ExcessiveAttemptsException) {
            return "\u5c1d\u8bd5\u6b21\u6570\u592a\u591a";
        }
        if (e instanceof AccountException) {
            String error = e.getMessage();
            if (StringUtils.isBlank((CharSequence)error)) {
                error = "\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e";
            }
            return error;
        }
        this.logger.debug("\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e", (Throwable)e);
        return "\u8d26\u6237\u6216\u5bc6\u7801\u4e0d\u6b63\u786e";
    }
}

