/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro;

import com.rocoinfo.rocomall.redis.JedisTemplate;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.util.Pool;

public class JedisManager {
    private Pool<Jedis> jedisPool;
    private int dbIndex;

    public Jedis getJedis() {
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.getJedisPool().getResource();
            jedis.select(this.dbIndex);
        }
        catch (Exception e) {
            throw new JedisConnectionException((Throwable)e);
        }
        return jedis;
    }

    public void returnResource(Jedis jedis, boolean isBroken) {
        if (jedis == null) {
            return;
        }
        if (isBroken) {
            this.getJedisPool().returnBrokenResource((Object)jedis);
        } else {
            this.getJedisPool().returnResource((Object)jedis);
        }
    }

    public byte[] getValueByKey(byte[] key) throws Exception {
        Jedis jedis = null;
        byte[] result = null;
        boolean isBroken = false;
        try {
            jedis = this.getJedis();
            result = jedis.get(key);
        }
        catch (Exception e) {
            isBroken = true;
            throw e;
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
        return result;
    }

    public Boolean del(String ... keys) {
        return (Boolean)this.execute((JedisTemplate.JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void deleteByKey(byte[] key) throws Exception {
        Jedis jedis = null;
        boolean isBroken = false;
        try {
            jedis = this.getJedis();
            jedis.del(key);
        }
        catch (Exception e) {
            isBroken = true;
            throw e;
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    public void saveValueByKey(byte[] key, byte[] value, int expireTime) throws Exception {
        Jedis jedis = null;
        boolean isBroken = false;
        try {
            jedis = this.getJedis();
            jedis.set(key, value);
            if (expireTime > 0) {
                jedis.expire(key, expireTime);
            }
        }
        catch (Exception e) {
            isBroken = true;
            throw e;
        }
        finally {
            this.returnResource(jedis, isBroken);
        }
    }

    public void execute(JedisTemplate.JedisActionNoResult jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = this.getJedis();
            jedisAction.action(jedis);
        }
        catch (JedisConnectionException e) {
            broken = true;
            throw e;
        }
        finally {
            this.returnResource(jedis, broken);
        }
    }

    public <T> T execute(JedisTemplate.JedisAction<T> jedisAction) throws JedisException {
        Jedis jedis = null;
        boolean broken = false;
        try {
            jedis = this.getJedis();
            Object object = jedisAction.action(jedis);
            return (T)object;
        }
        catch (JedisConnectionException e) {
            broken = true;
            throw e;
        }
        finally {
            this.returnResource(jedis, broken);
        }
    }

    public void setex(String key, String value, int seconds) {
        this.execute((JedisTemplate.JedisActionNoResult)new /* Unavailable Anonymous Inner Class!! */);
    }

    public String get(String key) {
        return (String)this.execute((JedisTemplate.JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean expire(String key, int seconds) {
        return (Boolean)this.execute((JedisTemplate.JedisAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Pool<Jedis> getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public int getDatabase() {
        return this.dbIndex;
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        this.dbIndex = index;
    }
}

