/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro;

import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.service.impl.AdminUserService;
import com.rocoinfo.rocomall.service.impl.UserService;
import com.rocoinfo.rocomall.shiro.ShiroUser;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.utils.Collections3;

public abstract class ShiroAbstractRealm
extends AuthorizingRealm {
    protected AdminUserService adminService;
    protected UserService userService;
    private Logger logger = LoggerFactory.getLogger(ShiroAbstractRealm.class);

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            ShiroUser shiroUser = (ShiroUser)principals.getPrimaryPrincipal();
            AdminUser adminUsr = (AdminUser)this.adminService.getById(shiroUser.getId());
            if (adminUsr != null) {
                this.adminService.buildAdminPermissionDetail(adminUsr);
                info.addRoles((Collection)this.getRoleNames(adminUsr));
                info.addStringPermissions((Collection)this.getPermissions(adminUsr));
            }
            return info;
        }
        catch (RuntimeException e) {
            this.logger.warn("\u6388\u6743\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private List<String> getRoleNames(AdminUser adminUsr) {
        return Collections3.extractToList((Collection)adminUsr.getRoles(), (String)"name");
    }

    private LinkedHashSet<String> getPermissions(AdminUser adminUsr) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty((Collection)adminUsr.getRoles())) {
            for (Role role : adminUsr.getRoles()) {
                permissions.addAll(role.getPermissions());
            }
        }
        return permissions;
    }

    public void setAdminService(AdminUserService adminService) {
        this.adminService = adminService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

