/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro;

import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.shiro.ShiroAbstractRealm;
import com.rocoinfo.rocomall.shiro.ShiroUser;
import com.rocoinfo.rocomall.shiro.token.MyUsernamePasswordToken;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.util.ByteSource;
import org.springside.modules.utils.Encodes;

public class ShiroDbRealm
extends ShiroAbstractRealm {
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        MyUsernamePasswordToken token = (MyUsernamePasswordToken)authcToken;
        AdminUser user = null;
        if (UserType.ADMIN.equals((Object)token.getUserType())) {
            user = this.adminService.getAdminByUsername(token.getUsername());
        }
        if (UserType.MEMBER.equals((Object)token.getUserType())) {
            user = this.userService.getByUsername(token.getUsername());
        }
        if (user == null) {
            throw new AccountException("\u4e0d\u5b58\u5728\u7528\u6237\uff1a" + token.getUsername());
        }
        ShiroUser shiroUser = null;
        String password = null;
        byte[] salt = null;
        if (user instanceof AdminUser) {
            AdminUser adminUser = user;
            if (adminUser.getStatus().equals((Object)SwitchStatus.LOCK)) {
                throw new LockedAccountException();
            }
            shiroUser = new ShiroUser(adminUser.getId(), adminUser.getUsername(), adminUser.getName());
            password = adminUser.getPassword();
            salt = Encodes.decodeHex((String)adminUser.getSalt());
        }
        if (user instanceof User) {
            User member = (User)user;
            if (member.getStatus().equals((Object)SwitchStatus.LOCK)) {
                throw new LockedAccountException();
            }
            shiroUser = new ShiroUser(member.getId(), member.getUsername(), member.getName());
            password = member.getPassword();
            salt = Encodes.decodeHex((String)member.getSalt());
        }
        return new SimpleAuthenticationInfo(shiroUser, password, ByteSource.Util.bytes(salt), this.getName());
    }
}

