/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.cache;

import com.rocoinfo.rocomall.shiro.JedisManager;
import com.rocoinfo.rocomall.utils.SerializeUtil;
import java.util.Collection;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JedisShiroCache<K, V>
implements Cache<K, V> {
    private static final String REDIS_SHIRO_CACHE = "shiro-cache:";
    private JedisManager jedisManager;
    private String name;
    private Logger logger = LoggerFactory.getLogger(JedisShiroCache.class);

    public JedisShiroCache(String name, JedisManager jedisManager) {
        this.name = name;
        this.jedisManager = jedisManager;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V get(K key) throws CacheException {
        byte[] byteKey = SerializeUtil.serialize((Object)this.buildCacheKey(key));
        byte[] byteValue = new byte[]{};
        try {
            byteValue = this.jedisManager.getValueByKey(byteKey);
        }
        catch (Exception e) {
            this.logger.warn("get cache error", (Throwable)e);
        }
        return (V)SerializeUtil.deserialize((byte[])byteValue);
    }

    public V put(K key, V value) throws CacheException {
        Object previos = this.get(key);
        try {
            this.jedisManager.saveValueByKey(SerializeUtil.serialize((Object)this.buildCacheKey(key)), SerializeUtil.serialize(value), -1);
        }
        catch (Exception e) {
            this.logger.warn("put cache error", (Throwable)e);
        }
        return (V)previos;
    }

    public V remove(K key) throws CacheException {
        Object previos = this.get(key);
        try {
            this.jedisManager.deleteByKey(SerializeUtil.serialize((Object)this.buildCacheKey(key)));
        }
        catch (Exception e) {
            this.logger.warn("remove cache error", (Throwable)e);
        }
        return (V)previos;
    }

    public void clear() throws CacheException {
    }

    public int size() {
        if (this.keys() == null) {
            return 0;
        }
        return this.keys().size();
    }

    public Set<K> keys() {
        return null;
    }

    public Collection<V> values() {
        return null;
    }

    private String buildCacheKey(Object key) {
        return REDIS_SHIRO_CACHE + this.getName() + ":" + key;
    }
}

