/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.shiro.filter;

import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.service.impl.AdminUserService;
import com.rocoinfo.rocomall.utils.WebUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.UserFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springside.modules.utils.Encodes;

@Component
public class MultipleViewUserFilter
extends UserFilter {
    private static final String USR_ID = "userId";
    @Autowired
    private AdminUserService adminService;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Long loggedUserId = WebUtils.getLoggedUserId();
        if (null != loggedUserId) {
            AdminUser admin = (AdminUser)this.adminService.getById(loggedUserId);
            if (admin == null) {
                return false;
            }
            if (admin.getStatus() == SwitchStatus.LOCK) {
                Subject subject = this.getSubject(request, response);
                subject.logout();
                request.setAttribute(USR_ID, (Object)loggedUserId);
                return false;
            }
        }
        return super.isAccessAllowed(request, response, mappedValue);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String ctx = req.getSession().getServletContext().getContextPath();
        String path = req.getRequestURI().substring(ctx.length());
        Object userId = request.getAttribute(USR_ID);
        if (WebUtils.isAjaxRequest((HttpServletRequest)req)) {
            resp.setStatus(userId != null ? 701 : 702);
        } else if (path.startsWith("/")) {
            StringBuilder loginUrl = new StringBuilder();
            loginUrl.append(ctx);
            loginUrl.append("/login");
            loginUrl.append("?successUrl=").append(this.getRedirectUrlOnLoginSuccess(req));
            resp.sendRedirect(loginUrl.toString());
        } else {
            return super.onAccessDenied(request, response);
        }
        return false;
    }

    private String getRedirectUrlOnLoginSuccess(HttpServletRequest req) {
        StringBuilder requestUrl = new StringBuilder(req.getRequestURL().toString());
        String queryString = req.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            requestUrl.append("?").append(queryString);
        }
        return Encodes.urlEncode((String)requestUrl.toString());
    }
}

